<?php
    function getPlanSeats($access, $plan){
        $getPlan = $access->query("SELECT seats FROM tbl_ticket_price WHERE price_id = '".$plan."'");
        $pSeats = $getPlan->fetch();
        return $pSeats['seats'];
    }
    function insertPayTrial($access, $event_id, $amount, $usNames, $usMail, $pay_4ne, $pay_mode, $paySts) {
        $sql = $access->prepare("INSERT INTO tbl_pay_trial(event_id, amount, usNames, usMail, pay_4ne, pay_mode, paySts) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $sql->execute([$event_id, $amount, $usNames, $usMail, $pay_4ne, $pay_mode, $paySts]);

        return $access->lastInsertId();
    }
    // add price_id,tcount,holders to pay trial with just request ref 
    function update_pay_trial_meta($access, $ptck_id,$req_ref, $price_id, $tcount, $holders, $financial_id){
        // $sql = $access->prepare("UPDATE tbl_pay_trial SET price_id = ?, tcount = ?, holders = ? WHERE req_ref = ?");
        // $sql->execute([$price_id, $tcount, $holders, $req_ref]);
        $sql = $access->prepare("UPDATE tbl_pay_trial SET price_id = ?, tcount = ?, holders = ?, financial_id = ? , req_ref = ? WHERE ptck_id = ?");
        $sql->execute([$price_id, $tcount, $holders, $financial_id, $req_ref, $ptck_id]);
        return;
    }
    // get pay trial data by request ref
    function get_pay_trial_by_req_ref($access, $req_ref){
        $sql = $access->query("SELECT * FROM tbl_pay_trial WHERE req_ref = '".$req_ref."'");
        return $sql->fetch();
    }

    function updatePayTrial($access, $req_ref, $lastId) {
        $sql = $access->prepare("UPDATE tbl_pay_trial SET req_ref = ?, paySts = 4 WHERE ptck_id = ?");
        $sql->execute([$req_ref, $lastId]);
        return;
    }

    function insertPayTicket($access, $ticket, $uniqueId, $amount, $names, $phone, $email, $payMode, $ev) {
        $ref = createRef($ticket);
        $sql = $access->prepare("INSERT INTO tbl_pay_tickets(con_tck, req_ref, ptransid, amount, usNames, pay_4ne, usMail, paySts, post, pay_mode, event_id) VALUES (?, ?, ?, ?, ?, ?, ?, 4, 1, ?, ?)");
        $sql->execute([$ticket, $ref, $uniqueId, $amount, $names, $phone, $email, $payMode, $ev]);
        return;
    }

    function updateConTicket($access, $ticket) {
        $sql = $access->prepare("UPDATE tbl_con_tickets SET tck_status = 4 WHERE con_tck_id = ?");
        $sql->execute([$ticket]);
        return $ticket;
    }

    function manageTicketsAndNotify($access, $currency, $isSupport, $req_ref, $lastId, $plan, $seats, $event, $amount, $names, $phone, $email, $payMode){
        if ($isSupport == 0) {
            updatePayTrial($access, $req_ref, $lastId);
            
            $getTickets = $access->query('SELECT con_tck_id FROM tbl_con_tickets WHERE price_id="'.$plan.'" AND tck_status = 3 ORDER BY con_tck_id ASC LIMIT '.$seats);
            if ($getTickets->rowCount() > 0) {
                $tickets = array();
                $tmount = $amount/$seats;
                $index = 0;
                while($sticket = $getTickets->fetch()){
                    $ticket = $sticket['con_tck_id'];
                    array_push($tickets, $ticket);
                    insertPayTicket($access, $ticket, $req_ref, $tmount, $names[$index], $phone, $email, $payMode, $event);
                    updateConTicket($access, $ticket);
                    $index += 1;
                }
                
                sendSMSToClient($access, $currency, $isSupport, $event, $tickets, $phone, $names[0]);
                sendEmailToClient($access, $currency, $tickets, $event, $email, $names[0]);
                sendSMSToManager($access, $currency, $event, $amount, $names[0], $phone);
                
            }
        }
        return;
    }
    
    function manageSupport($access, $currency, $uniqueId, $lastId, $event, $amount, $usNames, $phone, $email, $pmode){
        updatePayTrial($access, $uniqueId, $lastId);
        $tickets = array();
        $sql = $access->prepare("INSERT INTO tbl_event_support(ptransid, amount, usNames, pay_4ne, usMail, paySts, post, pay_mode, event_id) VALUES (:req_ref, :amount, :usNames, :pay_4ne, :usMail, 4, 1, :pay_mode, :event_id)");
        $sql->bindParam(':req_ref', $uniqueId);
        $sql->bindParam(':amount', $amount);
        $sql->bindParam(':usNames', $usNames);
        $sql->bindParam(':pay_4ne', $phone);
        $sql->bindParam(':usMail', $email);
        $sql->bindParam(':pay_mode', $pmode);
        $sql->bindParam(':event_id', $event);
        if ($sql->execute()) {
            sendSMSToClient($access, $currency, 1, $event, $tickets, $phone, $usNames);
            sendEmailToClientSupport($access, $currency, $event, $email, $usNames);
            sendSMSToManager($access, $currency, $event, $amount, $usNames, $phone);
        }
        return;
    }
?>