<?php
ob_start();
ini_set('log_errors', 0);
require('com/files/utils/functions.php');
require('com/config/connect.php');

function decryptURL($tickets)
{
    $encryptedData = $tickets;
    $decodedData = urldecode($encryptedData);
    $json = base64_decode($decodedData);
    $decrypted = json_decode($json, true);
    return $decrypted;
}

$queryString = $_SERVER['QUERY_STRING'];
$tID = substr($queryString, 2);
$ticketIds = decryptURL($tID);
$tckCount = count($ticketIds);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Tickets</title>
    <style>
        body {
            background-color: #f5f7fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            padding-bottom: 40px;
            margin: 0;
            line-height: 1.5;
        }

        .container {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
            max-width: 1140px;
        }

        .row {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin: 0 -15px;
        }

        .col-lg-6 {
            padding: 0 15px;
        }

        .text-center {
            text-align: center;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .mr-2 {
            margin-right: 0.5rem;
        }

        .lead {
            font-size: 1.25rem;
            font-weight: 300;
        }

        .text-danger {
            color: #dc3545;
        }

        /* Custom Styles */
        .header-section {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            padding: 20px 0;
            margin-bottom: 30px;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .welcome-message {
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
        }

        .welcome-message h1 {
            font-size: 1.8rem;
            margin-bottom: 10px;
        }

        .welcome-message .lead {
            font-size: 1.1rem;
            margin-bottom: 8px;
        }

        .welcome-message p {
            margin-bottom: 5px;
        }

        .header-icon {
            font-size: 2rem;
            margin-bottom: 10px;
            display: inline-block;
        }

        .card {
            border: none;
            margin-bottom: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            border-radius: 12px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            background: white;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }

        .card-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid #eaeaea;
            padding: 15px 20px;
            border-radius: 12px 12px 0 0 !important;
        }

        .card-body {
            padding: 25px;
        }

        .info-row {
            margin-bottom: 8px;
        }

        .info-label {
            font-weight: 600;
            color: #555;
        }

        .info-value {
            color: #333;
        }

        .btn {
            display: inline-block;
            font-weight: 600;
            color: white;
            text-align: center;
            vertical-align: middle;
            user-select: none;
            background-color: transparent;
            border: 1px solid transparent;
            padding: 10px 25px;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: 50px;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .btn-primary {
            background: #4066E0;
            border: none;
            box-shadow: 0 4px 10px rgba(64, 102, 224, 0.3);
        }

        .btn-primary:hover {
            background: #3050C5;
            box-shadow: 0 6px 15px rgba(64, 102, 224, 0.4);
        }

        .btn-success {
            background: #2EC973;
            border: none;
            box-shadow: 0 4px 10px rgba(46, 201, 115, 0.3);
        }

        .btn-success:hover {
            background: #27B566;
            box-shadow: 0 6px 15px rgba(46, 201, 115, 0.4);
        }

        .btn-lg {
            padding: 0.5rem 1rem;
            font-size: 1.25rem;
            line-height: 1.5;
            border-radius: 50px;
        }

        .download-all {
            margin: 30px 0;
            text-align: center;
        }

        .ticket-icon {
            margin-right: 8px;
        }

        .event-title {
            margin: 0;
            font-weight: 700;
            color: #2d3748;
        }

        .download-button {
            margin-top: 15px;
            display: inline-block;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            padding: 15px 0;
            border-top: 1px solid #eaeaea;
            color: #6c757d;
        }

        .footer a {
            color: #4066E0;
            text-decoration: none;
            font-weight: 500;
        }

        .footer a:hover {
            text-decoration: underline;
        }

        .footer-brand {
            margin-top: 10px;
            font-size: 0.9rem;
        }

        /* Icon replacements with Unicode symbols */
        .icon-ticket:before {
            content: "🎟️ ";
        }

        .icon-calendar:before {
            content: "📅 ";
        }

        .icon-time:before {
            content: "🕒 ";
        }

        .icon-tag:before {
            content: "🏷️ ";
        }

        .icon-table:before {
            content: "🪑 ";
        }

        .icon-seat:before {
            content: "💺 ";
        }

        .icon-category:before {
            content: "🎭 ";
        }

        .icon-price:before {
            content: "💰 ";
        }

        .icon-user:before {
            content: "👤 ";
        }

        .icon-purchase:before {
            content: "🛒 ";
        }

        .icon-download:before {
            content: "⬇️ ";
        }

        .icon-heart:before {
            content: "❤️ ";
        }

        /* Responsive layout */
        @media (max-width: 768px) {
            .row {
                grid-template-columns: 1fr;
            }
        }

        @media (min-width: 768px) and (max-width: 991px) {
            .row {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (min-width: 992px) {
            .row {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>

<body>
    <div class="header-section">
        <div class="container welcome-message">
            <div class="header-icon">🎟️</div>
            <h1>Your Tickets Are Ready!</h1>
            <p class="lead">Thank you for your purchase. We're excited to see you at the event!</p>
        </div>
    </div>

    <div class="container">
        

        <div class="download-all">
            <a href="ticket.php?<?php echo $queryString; ?>" class="btn btn-success btn-lg" target="_blank" download>
                <span class="icon-download"></span>Download All <?php echo $tckCount; ?> Tickets
            </a>
        </div>

        <div class="row">
            <?php
            foreach ($ticketIds as $ticketId) {
                $conTick = $db->query('SELECT c.*, 
                                        t.price_plan, 
                                        t.ticket_file,
                                        t.seats,
                                        t.seat_index AS seating,
                                        pay.usNames,
                                        pay.pay_4ne,
                                        pay.trm_time
                                        FROM tbl_con_tickets c
                                            INNER JOIN tbl_ticket_price t ON c.price_id = t.price_id
                                            INNER JOIN tbl_pay_tickets pay ON c.con_tck_id = pay.con_tck
                                        WHERE c.con_tck_id="' . $ticketId . '" AND c.tck_status=4
                                    ');
                $CountTckNum = $conTick->rowCount();
                if ($CountTckNum > 0) {
                    $ticket = $conTick->fetch();
                    $eventData = $db->query('SELECT * FROM tbl_events WHERE evt_id="' . $ticket['evt_id'] . '"');
                    $event = $eventData->fetch();

                    $eventName = $event['evtname'];
                    $date = $event['start_date'];
                    $tcode = $ticket['tcode'];
                    $plan = $ticket['price_plan'];
                    $price = $ticket['price'];
                    $owner = $ticket['usNames'];
                    $purchased = date("l, d M Y, H:i", strtotime($ticket['trm_time'] . ' +1 hour'));
            ?>

                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="event-title"><span class="icon-calendar"></span><?php echo strtoupper($eventName); ?></h5>
                            </div>
                            <div class="card-body">
                                <?php if ($ticket['seating'] != $ticket['seats']): ?>
                                    <div class="info-row">
                                        <span class="info-label"><span class="icon-table"></span>Table:</span>
                                        <span class="info-value"><?php echo $ticket['seat_no']; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label"><span class="icon-seat"></span>Seat number:</span>
                                        <span class="info-value"><?php echo $ticket['seat_index']; ?></span>
                                    </div>
                                <?php else: ?>
                                    <div class="info-row">
                                        <span class="info-label"><span class="icon-seat"></span>Seat number:</span>
                                        <span class="info-value"><?php echo $ticket['seat_no']; ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="info-row">
                                    <span class="info-label"><span class="icon-calendar"></span>Date:</span>
                                    <span class="info-value"><?php echo date("l, d M Y", strtotime($date)); ?></span>
                                </div>

                                <div class="info-row">
                                    <span class="info-label"><span class="icon-time"></span>Time:</span>
                                    <span class="info-value"><?php echo date("H:i", strtotime($date)); ?></span>
                                </div>



                                <div class="info-row">
                                    <span class="info-label"><span class="icon-category"></span>Category:</span>
                                    <span class="info-value"><?php echo strtoupper($plan); ?></span>
                                </div>

                                <div class="info-row">
                                    <span class="info-label"><span class="icon-price"></span>Price:</span>
                                    <span class="info-value"><?php echo number_format($price) . ' ' . $currency; ?></span>
                                </div>

                                <div class="info-row">
                                    <span class="info-label"><span class="icon-user"></span>Owner:</span>
                                    <span class="info-value"><?php echo $owner; ?></span>
                                </div>

                                <div class="info-row">
                                    <span class="info-label"><span class="icon-purchase"></span>Purchased:</span>
                                    <span class="info-value"><?php echo $purchased; ?></span>
                                </div>

                                <div class="download-button">
                                    <a href="ticket.php?t=<?php echo urlencode(base64_encode(json_encode([$ticketId]))); ?>" class="btn btn-primary" target="_blank" download>
                                        <span class="icon-download"></span>Download Ticket
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

            <?php
                }
            }
            ?>
        </div>
        <div class="footer">
            <p>We hope you enjoy the event! If you have any questions about your tickets, please contact our support team.</p>
            <p><span class="icon-heart"></span> Thank you for your purchase!</p>
            <div class="footer-brand">
                Powered by <a href="https://itec.rw" target="_blank">ITEC Ltd</a>
            </div>
        </div>
    </div>
</body>

</html>

<?php
ob_end_flush();
?>