<?php /** Author: @hicode **/ ?>
<?php
    ob_start(); 
    require('../../files/fpdf/fpdf.php');
    require('../../config/connect.php');
    require('../../files/utils/functions.php');

    function doc_header($pdf, $sys, $location, $web, $phone, $email, $event_name, $owner_name){
		$pdf->SetX(70);
		$pdf->SetFont('Times', 'B', 16);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, strtoupper($sys), 0, 0, 'R');
		$pdf->Ln(6);
		
		$pdf->SetFont('Times', 'B', 12);
		$pdf->SetTextColor(0, 0, 0);
		
		$pdf->SetX(70);
		$pdf->Cell(120, 5, $location, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(70);
		$pdf->Cell(120, 5, 'Website: '.$web, 0, 0, 'R');
		$pdf->Ln(5);
		 
		$pdf->SetX(70);
		$pdf->Cell(120, 5, 'Tel: '.$phone, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(70);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, 'Email: '.$email,0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'Event: '.$event_name, 0, 0, 'L');
		$pdf->Ln(5);
		
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'To: '.$owner_name,0, 0, 'L');
		$pdf->Ln(15);
		
		$pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
		$pdf->Ln();
    }
    //Page footer
    function page_footer($pdf, $syslink){
        $time = date('Y-m-d H:i:s', strtotime('+2hours'));
        $pdf->SetY(-28);
	    $pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
	    $pdf->Ln(1);
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->SetFont('Times', '', 11);
    	$pdf->SetTextColor(53, 75, 136);
    	$pdf->Cell(100, 6, substr($syslink, 8), 0, 0, 'L');
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->Cell(90, 6, 'GENERATED:  '.$time, 0, 0, 'R');
    	$pdf->Ln();
    } 
    
    $pdf=new FPDF();
    
    $event = $_REQUEST['ev'];
    $plan = $_REQUEST['pln'];
    
    $query = $conn->prepare("SELECT ev.*, o.owner_name FROM tbl_events ev INNER JOIN tbl_event_owners o ON ev.owner_id = o.owner_id WHERE ev.evt_id = ?");
    $query->execute([$event]);
    $eventData = $query->fetch();
    
    $pdf->SetAuthor(substr($syslink, 8));
    $pdf->SetTitle('Report - '.$eventData['evtname']);
    $pdf->AddPage('P');
    doc_header($pdf, $sys, $syslocation, $sysweb, $sysphone, $sysemail, $eventData['evtname'], $eventData['owner_name']);

    $getPlanName = $conn->prepare("SELECT price_plan FROM tbl_ticket_price WHERE price_id = ?");
    $getPlanName->execute([$plan]);
    $plan_name = $getPlanName->fetch()['price_plan'];
    try {
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetFont('Arial', 'B', 13);
		$pdf->Cell(200, 10, "TICKET BUYERS - ".$plan_name, 0, 0, 'C');
		$pdf->Ln(15);
        $pdf->SetFont('Times', 'B', 12);
        
        $pdf->Cell(6, 6, '');
        $pdf->Cell(25, 6, 'S/N', 1);
        $pdf->Cell(75, 6, 'BUYER NAMES', 1); 
        $pdf->Cell(50, 6, 'PHONE / EMAIL', 1); 
        $pdf->Cell(30, 6, 'SEAT NO', 1); 
        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
        
        $query = "SELECT 
                        pt.usNames, 
                        pt.pay_4ne,
                        c.seat_no
                    FROM 
                        tbl_pay_tickets pt 
                            INNER JOIN tbl_con_tickets c ON pt.con_tck = c.con_tck_id
                    WHERE
                        c.evt_id = ? AND 
                        c.price_id = ?
                    ";
        $paidTickets = $conn->prepare($query);
        $paidTickets->execute([$event, $plan]);
        
        $index = 1;
        while($tickets = $paidTickets->fetch()){

            $pdf->Cell(6, 6, '');
            $pdf->Cell(25, 6, $index++, 1);
            $pdf->Cell(75, 6, $tickets['usNames'], 1);
            $pdf->Cell(50, 6, $tickets['pay_4ne'], 1);
            $pdf->Cell(30, 6, $tickets['seat_no'], 1); 
            $pdf->Ln();

            if($pdf->GetY()>=250){
                $pdf->AddPage('P');
            }
        }

        page_footer($pdf, $syslink);
    }catch (PDOException $ex) {
        echo $ex->getMessage();
    }

    $dname = generatefile_v2();
    $pdf->Output($dname.'.pdf','I');
    ob_end_flush();
?>

