<?php /** Author: @hicode **/ ?>
<?php
    ob_start(); 
    require('../../files/fpdf/fpdf.php');
    require('../../config/connect.php');
    require('../../files/utils/functions.php');

    function doc_header($pdf, $sys, $location, $web, $phone, $email, $event_name, $owner_name){
		$pdf->SetX(150);
		$pdf->SetFont('Times', 'B', 16);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, strtoupper($sys), 0, 0, 'R');
		$pdf->Ln(6);
		
		$pdf->SetFont('Times', 'B', 12);
		$pdf->SetTextColor(0, 0, 0);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, $location, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Website: '.$web, 0, 0, 'R');
		$pdf->Ln(5);
		 
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Tel: '.$phone, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, 'Email: '.$email,0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'Event: '.$event_name, 0, 0, 'L');
		$pdf->Ln(5);
		
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'To: '.$owner_name,0, 0, 'L');
		$pdf->Ln(15);
		
		$pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
		$pdf->Ln();
    }
    //Page footer
    function page_footer($pdf, $syslink){
        $time = date('Y-m-d H:i:s', strtotime('+2hours'));
        $pdf->SetY(-28);
	    $pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
	    $pdf->Ln(1);
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->SetFont('Times', '', 11);
    	$pdf->Cell(12, 6, '');
    	$pdf->SetTextColor(53, 75, 136);
    	$pdf->Cell(125, 6, substr($syslink, 8), 0, 0, 'L');
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->Cell(125, 6, 'GENERATED:  '.$time, 0, 0, 'R');
    	$pdf->Ln();
    } 
    
    $pdf=new FPDF();
    
    $event = $_REQUEST['ev'];
    $post = $_REQUEST['post'];
    $type = $_REQUEST['rep'];
    $total = 0;
    
    $query = $conn->prepare("SELECT ev.*, o.owner_name FROM tbl_events ev INNER JOIN tbl_event_owners o ON ev.owner_id = o.owner_id WHERE ev.evt_id = ?");
    $query->execute([$event]);
    $eventData = $query->fetch();
    
    $pdf->SetAuthor(substr($syslink, 8));
    $pdf->SetTitle('Report - '.$eventData['evtname']);
    $pdf->AddPage('L');
    doc_header($pdf, $sys, $syslocation, $sysweb, $sysphone, $sysemail, $eventData['evtname'], $eventData['owner_name']);

    try {
        switch($type){
            case 1:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "TICKET SALES REPORT | BY BUYERS", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(75, 6, 'BUYER NAMES', 1); 
                    $pdf->Cell(50, 6, 'PHONE / EMAIL', 1); 
                    $pdf->Cell(35, 6, 'TICKET VALUE', 1);
                    $pdf->Cell(25, 6, 'POST', 1);
                    $pdf->Cell(25, 6, 'COUNT', 1);
                    $pdf->Cell(30, 6, 'SUM', 1);

                    $pdf->Ln();
                    
                    $pdf->SetFont('Times', '', 12);
                    
                    if($post == 1 || $post == 0){
                        $query = "SELECT COUNT(amount) AS number, pay_4ne, usNames, amount, post FROM tbl_pay_tickets where event_id = ?  AND post = '".$post."' GROUP BY amount, pay_4ne, post ORDER BY trm_time ASC";
                    } else{
                        $query = "SELECT COUNT(amount) AS number, pay_4ne, usNames, amount, post FROM tbl_pay_tickets where event_id = ? GROUP BY amount, pay_4ne, post ORDER BY trm_time ASC";
                    }
                    
                    $personalTickets=$conn->prepare($query);
                    $personalTickets->execute([$event]);
                    $pager = $personalTickets->rowCount();
                    $counter = 1;
                    $TOTAL_VALUE = 0;
                    $count_sum = 0;
                    while($tickets = $personalTickets->fetch()){
                        $TOTAL_VALUE += ($tickets['number']*$tickets['amount']);
                        $count_sum += $tickets['number'];
                        $source = "Online";
                        if($tickets['post'] == 0){
                            $source = "HardC";
                        }
                        $total += $tickets['amount'];
 
                        $pdf->Cell(12, 6, '');
                        $pdf->Cell(25, 6, $counter++, 1);
                        $pdf->Cell(75, 6, $tickets['usNames'], 1);
                        $pdf->Cell(50, 6, $tickets['pay_4ne'], 1); 
                        $pdf->Cell(35, 6, number_format($tickets['amount']), 1); 
                        $pdf->Cell(25, 6, $source, 1); 
                        $pdf->Cell(25, 6, number_format($tickets['number']), 1); 
                        $pdf->Cell(30, 6, $currency." ".number_format($tickets['number']*$tickets['amount']), 1);
                        $pdf->Ln();
                        if($pdf->GetY()>=175 && $counter<=$pager){
                            $pdf->AddPage('L');
                        }
                    }
                    // $pdf->SetFont('Times', 'B', 12);
                    // $pdf->Cell(12, 6, '');
                    // $pdf->Cell(235, 6, 'Total', 1);
                    // // $pdf->Cell(50, 6, $currency." ".number_format($total), 1); 
                    // $pdf->Cell(30, 6, $currency." ".number_format($TOTAL_VALUE), 1);
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(210, 6, 'Total', 1);
                    $pdf->Cell(25, 6, number_format($count_sum), 1);
                    $pdf->Cell(30, 6, $currency." ".number_format($TOTAL_VALUE), 1);

                }
                break;
                
            case 2:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "TICKET SALES REPORT | BY PRICE", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(60, 6, 'BUYER NAMES', 1);
                    $pdf->Cell(40, 6, 'PHONE / EMAIL', 1);
                    $pdf->Cell(40, 6, 'PLAN', 1); 
                    $pdf->Cell(30, 6, 'PRICE', 1); 
                    $pdf->Cell(30, 6, 'POST', 1); 
                    $pdf->Cell(30, 6, 'COUNT', 1); 
                    
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);

                    if($post == 1 || $post == 0){
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ? AND post = '".$post."'";
                    } else{
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ?";
                    }
                
                    $plans = $conn->prepare($query);
                    $plans->execute([$event]);
                    $counter = 1;
                    while($pln = $plans->fetch()){
                        $ticketCount = $conn->prepare("SELECT COUNT(pt.con_tck) AS number,pt.amount, SUM(pt.amount) AS pay, pt.usNames, pt.pay_4ne, pt.post
                                                    FROM tbl_pay_tickets pt 
                                                    INNER JOIN tbl_con_tickets c ON pt.con_tck = c.con_tck_id WHERE c.price_id = ?
                                                    GROUP BY pt.pay_4ne, pt.post, pt.amount");
            
                        $ticketCount->execute([$pln['price_id']]);
                        while($tickets = $ticketCount->fetch()){
                            $source = "Online";
                            if($tickets['post'] == 0){
                                $source = "HardC";
                            }
                        
                            $total += $tickets['pay'];
            
                            $pdf->Cell(12, 6, '');
                            $pdf->Cell(25, 6, $counter++, 1);
                            $pdf->Cell(60, 6, $tickets['usNames'], 1);
                            $pdf->Cell(40, 6, $tickets['pay_4ne'], 1); 
                            $pdf->Cell(40, 6, $pln['price_plan'], 1); 
                            $pdf->Cell(30, 6, number_format($tickets['amount']), 1); 
                            $pdf->Cell(30, 6, $source, 1); 
                            $pdf->Cell(30, 6, number_format($tickets['number']/$pln['seats']), 1);
                            $pdf->Ln();
                            if($pdf->GetY()>=175){
                                $pdf->AddPage('L');
                            }
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(195, 6, 'Total', 1);
                    $pdf->Cell(60, 6, $currency." ".number_format($total), 1); 
                }
                break;
                
            case 3:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "TICKET SALES REPORT | BY COUNT", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(60, 6, 'PLAN', 1);
                    $pdf->Cell(40, 6, 'PRICE', 1);
                    $pdf->Cell(40, 6, 'POST', 1); 
                    $pdf->Cell(40, 6, 'COUNT', 1);
                    $pdf->Cell(50, 6, 'TOTAL', 1);
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    if($post == 1 || $post == 0){
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ? AND post = '".$post."'";
                    } else{
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ?";
                    }
                
                    $plans = $conn->prepare($query);
                    $plans->execute([$event]);
                    $counter = 1;
                    while($pln = $plans->fetch()){
                        $ticketCount=$conn->prepare("SELECT COUNT(pt.con_tck) AS number, pt.post, pt.amount 
                                                                FROM tbl_pay_tickets pt 
                                                                INNER JOIN tbl_con_tickets c ON pt.con_tck = c.con_tck_id WHERE c.price_id = ? GROUP BY pt.amount");
                                                                
                        $ticketCount->execute([$pln['price_id']]);
                        while($tickets = $ticketCount->fetch()){
                            $source = "Online";
                            if($tickets['post'] == 0){
                                $source = "HardC";
                            }
                            $rAmount = $tickets['amount']*($tickets['number']);
                            $total += $rAmount;
            
                            $pdf->Cell(12, 6, '');
                            $pdf->Cell(25, 6, $counter++, 1);
                            $pdf->Cell(60, 6, $pln['price_plan'], 1);
                            $pdf->Cell(40, 6, number_format($tickets['amount'] * $pln['seats']), 1); 
                            $pdf->Cell(40, 6, $source, 1); 
                            $pdf->Cell(40, 6, number_format($tickets['number']/$pln['seats']), 1); 
                            $pdf->Cell(50, 6, number_format($rAmount), 1); 
                            $pdf->Ln();

                            if($pdf->GetY()>=175){
                                $pdf->AddPage('L');
                            }
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(205, 6, 'Total', 1);
                    $pdf->Cell(50, 6, $currency." ".number_format($total, 1), 1); 
                }
                break;
                
            case 4:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "TICKET SALES REPORT | BY TICKETS", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(70, 6, 'BUYER NAMES', 1);
                    $pdf->Cell(40, 6, 'PHONE / EMAIL', 1);
                    $pdf->Cell(35, 6, 'TICKET VALUE', 1); 
                    $pdf->Cell(45, 6, 'TIMESTAMP', 1); 
                    $pdf->Cell(35, 6, 'POST', 1); 
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    if($post == 1 || $post == 0){
                        $query = "SELECT * FROM tbl_pay_tickets where event_id = ? AND post = '".$post."' ORDER BY trm_time ASC";
                    } else{
                        $query = "SELECT * FROM tbl_pay_tickets where event_id = ? ORDER BY trm_time ASC";
                    }
                    $paidTickets = $conn->prepare($query);
                    $paidTickets->execute([$event]);
                    
                    $counter = 1;
                    while($tickets = $paidTickets->fetch()){
                        $source = "Online";
                        if($tickets['post'] == 0){
                            $source = "HardC";
                        }
                        $total += $tickets['amount'];
        
                        $pdf->Cell(12, 6, '');
                        $pdf->Cell(25, 6, $counter++, 1);
                        $pdf->Cell(70, 6, $tickets['usNames'], 1);
                        $pdf->Cell(40, 6, $tickets['pay_4ne'], 1); 
                        $pdf->Cell(35, 6, number_format($tickets['amount']), 1); 
                        $pdf->Cell(45, 6, $tickets['trm_time'], 1); 
                        $pdf->Cell(35, 6, $source, 1); 
                        $pdf->Ln();
                        
                        if($pdf->GetY()>=175){
                            $pdf->AddPage('L');
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(170, 6, 'Total', 1);
                    $pdf->Cell(80, 6, $currency." ".number_format($total, 1), 1); 
                }
                break;
                
            case 5:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "TICKET SCAN REPORT", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(60, 6, 'PLAN', 1);
                    $pdf->Cell(40, 6, 'PRICE', 1);
                    $pdf->Cell(40, 6, 'POST', 1); 
                    $pdf->Cell(40, 6, 'COUNT', 1);
                    $pdf->Cell(50, 6, 'TOTAL', 1);
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    if($post == 1 || $post == 0){
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ? AND post = '".$post."'";
                    } else{
                        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ?";
                    }
                
                    $plans = $conn->prepare($query);
                    $plans->execute([$event]);
                    $counter = 1;
                    while($pln = $plans->fetch()){
                        $ticketCount=$conn->prepare("SELECT COUNT(con_tck_id) AS number, price FROM tbl_con_tickets WHERE price_id = ? AND tck_status = 5 GROUP BY price");
                                                                
                        $ticketCount->execute([$pln['price_id']]);
                        while($tickets = $ticketCount->fetch()){
                            $source = "Online";
                            if($pln['post'] == 0){
                                $source = "HardC";
                            }
                            $rAmount = $tickets['price']*$tickets['number'];
                            $total += $rAmount;
            
                            $pdf->Cell(12, 6, '');
                            $pdf->Cell(25, 6, $counter++, 1);
                            $pdf->Cell(60, 6, $pln['price_plan'], 1);
                            $pdf->Cell(40, 6, number_format($tickets['price'] * $pln['seats']), 1); 
                            $pdf->Cell(40, 6, $source, 1); 
                            $pdf->Cell(40, 6, number_format($tickets['number']), 1); 
                            $pdf->Cell(50, 6, number_format($rAmount), 1); 
                            $pdf->Ln();

                            if($pdf->GetY()>=175){
                                $pdf->AddPage('L');
                            }
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(205, 6, 'Total', 1);
                    $pdf->Cell(50, 6, $currency." ".number_format($total, 1), 1); 
                }
                break;
            
            
            default:
                {
                    
                }
            break;
        }

        page_footer($pdf, $syslink);
    }catch (PDOException $ex) {
        echo $ex->getMessage();
    }

    $dname = generatefile_v2();
    $pdf->Output($dname.'.pdf','I');
    ob_end_flush();
?>

