<?php
	function sendFeedback($status, $data){
        $data = array("status" => $status, "message" => $data);
        $jsonData = json_encode($data);
        echo $jsonData; 
	}

    function encryptTicket($tickets) {
        $json = json_encode($tickets);
        $encryptedData = base64_encode($json);
        $urlEncodedData = urlencode($encryptedData);
        return $urlEncodedData;
    }

    function generatefile() {
        $characters = '0123456789';
        $code = '';
    
        for ($i = 0; $i < 16; $i++) {
            $randomIndex = mt_rand(0, strlen($characters) - 1);
            $code .= $characters[$randomIndex];
        }
    
        return $code;
    }
    
    function getEventSMSName($access, $event) {
        $getEventData = $access->query("SELECT evtSMS FROM tbl_events WHERE evt_id = '".$event."'");
        $eventData = $getEventData->fetch();
        return $eventData['evtSMS'];
    }
    
    function getEventName($access, $event) {
        $getEventData = $access->query("SELECT evtname FROM tbl_events WHERE evt_id = '".$event."'");
        $eventData = $getEventData->fetch();
        return $eventData['evtname'];
    }
    
    function getSupportNumber($access, $event) {
        $getEventData = $access->query("SELECT telSupp FROM tbl_events WHERE evt_id = '".$event."'");
        $eventData = $getEventData->fetch();
        return $eventData['telSupp'];
    }
    
    function getEventManagerPhone($access, $event) {
        $getEventData = $access->query("SELECT telMnge FROM tbl_events WHERE evt_id = '".$event."'");
        $eventData = $getEventData->fetch();
        return $eventData['telMnge'];
    }
    
    function getEventManagerPhone2($access, $event) {
        $getEventData = $access->query("SELECT telMnge2 FROM tbl_events WHERE evt_id = '".$event."'");
        $eventData = $getEventData->fetch();
        return $eventData['telMnge2'];
    }
    
    function generateAttachment($ticketIds, $db, $currency){
        ob_start(); 
        $tckCount = count($ticketIds);
        
        $pdf=new FPDF();
        $pdf->AliasNbPages();
        
        $pdf->SetAuthor('ITEC');
        $pdf->SetTitle('Ticket');
        $pdf->SetTextColor(0,0,0);
        $pdf->SetFillColor(255,255,255);
        $pdf->SetDrawColor(255, 255, 255);
        $pdf->SetLineWidth(0.01);
        $pdf->SetAutoPageBreak(false);
        
        $x = 0;
        $y = 0;
        $c = 0;
    
        foreach($ticketIds as $ticketId){
            $pdf->AddPage('L', [210, 98]);
            $conTick = $db->query('SELECT c.*, 
                                            t.price_plan, 
                                            t.ticket_file,
                                            t.seats,
                                            t.seat_index AS seating,
                                            pay.usNames,
                                            pay.pay_4ne,
                                            pay.trm_time
                                            FROM tbl_con_tickets c
                                                INNER JOIN tbl_ticket_price t ON c.price_id = t.price_id
                                                INNER JOIN tbl_pay_tickets pay ON c.con_tck_id = pay.con_tck
                                            WHERE c.con_tck_id="'.$ticketId.'" AND c.tck_status=4
                                        ');
            $CountTckNum = $conTick->rowCount();
            if($CountTckNum>0){
                $ticket = $conTick->fetch();
                $eventData = $db->query('SELECT * FROM tbl_events WHERE evt_id="'.$ticket['evt_id'].'"');
                $event = $eventData->fetch();
                
                $eventName = $event['evtname'];
                $date = $event['start_date'];
                $support = $event['telSupp'];
                $door_open = $event['op_door'];
                
                $con_token = $ticket['con_token'];
                $tcode = $ticket['tcode'];
                $plan = $ticket['price_plan'];
                $ticket_file = $ticket['ticket_file'];
                $price = $ticket['price'];
                $owner = $ticket['usNames'];
                $owner_phone = $ticket['pay_4ne'];  
                
                $purchased = date("l, d M Y, H:i", strtotime($ticket['trm_time'] . ' +1 hour'));
                
                ##### MAIN #####
                
                $pdf->Image('../../..'.$ticket_file, $x, $y, 210, 98);
                
                $pdf->SetFont('helvetica', 'B', 12);
                $pdf->SetTextColor(64, 64, 64);
                $pdf->setXY($x+72, $y+25);
                $pdf->cell(90, 5, strtoupper($eventName), 0, 0, 'L');
    
                $pdf->setXY($x+72, $y+30);
                $pdf->SetFont('helvetica', '', 7);
                $pdf->SetTextColor(64, 64, 64);
                $pdf->cell(30, 4, date("l, d M Y", strtotime($date)), 0, 0, 'L');
                
                $pdf->setXY($x+72, $y+40);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Ticket ID:', 0);
                $pdf->SetFont('helvetica', '', 8); 
                $pdf->cell(15, 4, $tcode, 0, 0, 'L');

                if($ticket['seating'] != $ticket['seats']){
                    $pdf->Ln();
                    $pdf->setX($x+72);
                    $pdf->SetFont('helvetica', 'B', 8);
                    $pdf->cell(20, 4, 'Table:', 0);
                    $pdf->SetFont('helvetica', '', 8);
                    $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                    $pdf->Ln();
    
                    $pdf->setX($x+72);
                    $pdf->SetFont('helvetica', 'B', 8);
                    $pdf->cell(20, 4, 'Seat number:', 0);
                    $pdf->SetFont('helvetica', '', 8);
                    $pdf->cell(25, 4, $ticket['seat_index'], 0, 0, 'L');
                    $pdf->Ln();
                }else{
                    $pdf->Ln(6);
                    $pdf->setX($x+72);
                    $pdf->SetFont('helvetica', 'B', 8);
                    $pdf->cell(20, 4, 'Seat number:', 0);
                    $pdf->SetFont('helvetica', '', 8);
                    $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                    $pdf->Ln(); 
                }
                
                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Category:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, strtoupper($plan), 0, 0, 'L');
                $pdf->Ln();
                
                $pdf->setXY($x+107, $y+40);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(55, 4, $owner, 0, 0, 'C');
                $pdf->Ln();
                $pdf->setXY($x+120, $y+46);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(20, 4, 'Time:', 0);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, date("H:i", strtotime($date)), 0, 0, 'L');
                $pdf->Ln();
                $pdf->setXY($x+120, $y+50);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(20, 4, 'Door Open:', 0, 0, 'L');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, date("H:i", strtotime($door_open)), 0, 0, 'L');
                $pdf->Ln();
    
                $pdf->setXY($x+72, $y+58);
                $pdf->SetFont('helvetica', '', 7);
                $pdf->SetTextColor(64, 64, 64);
                $pdf->cell(40, 4, 'Price:', 0, 0, 'L');
                
                $pdf->SetFont('helvetica', 'B', 12);
                $pdf->SetTextColor(64, 64, 64);
                $pdf->setXY($x+72, $y+62);
                $pdf->cell(40, 5, number_format($price).' '.$currency, 0, 0, 'L');
                
                $pdf->SetFont('helvetica', '', 7);
                $pdf->SetTextColor(64, 64, 64);
                $pdf->setXY($x+72, $y+70);
                $pdf->cell(47, 4, 'Purchased: '.$purchased, 0, 0, 'L');
                $pdf->cell(43, 4, 'Support Line: '.$support, 0, 0, 'C');
                $pdf->cell(16, 4, 'Powered by:', 0, 0, 'R');
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->cell(14, 4, 'ITEC Ltd.', 0, 0, 'L');
                
                ##### END MAIN #####
                
                ##### QR #####
    
                $qr_file = "../tickets/export/QR/".$con_token.".png";
                QRcode::png($con_token, $qr_file, QR_ECLEVEL_Q, 10, 1);
                $pdf->Rect($x+167, $y+30, 25, 25, 'DF');
                $pdf->Image($qr_file, $x+168, $y+31, 23, 23);
                
                $pdf->setXY($x+167, $y+55);
                $pdf->SetFont('helvetica', '', 4);
                $pdf->cell(25, 4, 'This QR code is one time valid.', 0, 0, 'C');
                
                ##### END QR #####
            }
        }
        
        $folderPath = '../temp/';
        $pdfFilePath = $folderPath.generatefile(). '.pdf';
        $pdf->Output($pdfFilePath, 'F');
        return $pdfFilePath;
        exit;
        ob_end_flush();
    }
    
    function sendSMS($sender, $receiver, $message) {
        $data = array(
            "sender" => $sender,
            "recipients" => $receiver,
            "message" => $message,
        );
        $url = "https://www.intouchsms.co.rw/api/sendsms/.json";
        $data = http_build_query($data);
        $username = "twagiramungus";
        $password = "M00dle!!@@";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $result = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result;
        $httpcode;
    }

    function sendEmail($from, $to, $msg, $attachment, $eventName, $call_center){
        $year = date("Y");
        $subject = $eventName;                                
        
        $file_content = file_get_contents($attachment);
        
        $boundary = md5(uniqid(time()));
        
        // Set the email headers
        $headers = "From: $from\r\n";
        $headers .= "Reply-To: $from\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n";
        
        // compose message
        
        $message = '<html><head>';
        $message = ' <meta name="viewport" content="width=device-width, initial-scale=1.0" />';
        $message = ' <meta name="x-apple-disable-message-reformatting" />';
        $message = ' <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />';
        $message = ' <meta name="color-scheme" content="light dark" />';
        $message = ' <meta name="supported-color-schemes" content="light dark" />';
        $message = ' <title>IBITARAMO</title>';
        $message = '<body">';
        $message .= '
                    <div style="padding: 20px; border: 1px solid lightgray; font-family: Arial, sans-serif; background-color: #f5f5f5;">
                        <table style="width: 100%;">
                            <tbody>
                                <tr>
                                    <td style="text-align: center; color: #fff; font-weight: 600; padding: 30px; background-color: #6D071A;">
                                            IBITARAMO
                                    </td>
                                </tr>
                                <br>
                                '.$msg.'
                                <tr>
                                    <td>
                                        If you have other questions or issues, please contact our call center '.$call_center.' or and one of our customer representatives will be happy to assist.
                                    </td>
                                </td>
                                <tr>
                                  <td>
                                        <br>
                                        <p>Best regards,<br>Management</p>
                                  </td>
                                </tr>
                       
                                <tr>
                                    <td style="text-align: center; font-size: 14px; color: #fff; font-weight: 600; padding: 30px; background-color: #6D071A;">
                                        Powered by ITEC Ltd.<br>
                                        &copy; '.$year.' ITEC Ltd. All rights reserved.<br>
                                        KN 1 Rd, Kigali-Rwanda.<br>
                                        Tel: (+250) 788730582
                                    </td>
                                </tr>
                            </tbody>
                        </table> 
                    </div>';
        $message .= '</body></html>';
        
        
        
        // Set the email body
        $body = "--$boundary\r\n";
        $body .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        $body .= $message;
        $body .= "\r\n";
        $body .= "--$boundary\r\n";
        $body .= "Content-Type: application/pdf; name=\"" . basename($attachment) . "\"\r\n";
        $body .= "Content-Transfer-Encoding: base64\r\n";
        $body .= "Content-Disposition: attachment; filename=\"" . basename($attachment) . "\"\r\n\r\n";
        $body .= chunk_split(base64_encode($file_content));
        $body .= "--$boundary--";

        mail($to, $subject, $body, $headers);
        unlink($attachment);
        return;
    }
    function sendSMSToManager($access, $currency, $event, $amount, $payer, $payerTel) {
        $time = date("Y-m-d H:i:s");
        // $getTotal = $access->query("SELECT SUM(amount) as balance FROM tbl_pay_tickets WHERE event_id = '".$event."' AND paySts = 4 AND post = 1");
        // $total = $getTotal->fetch();
        // $balance = number_format($total['balance'], 0);
        
        $getTotal = $access->query("SELECT get_event_balance(".$event.") AS balance");
        $total = $getTotal->fetch();
        $balance = number_format($total['balance'], 0);    
        // Send SMS
        // $sender = getEventSMSName($access, $event);
        $sender = "ITECPAY";
        $receiver = getEventManagerPhone($access, $event);
        $receiver2 = getEventManagerPhone2($access, $event);
        $eventName = getEventName($access, $event);
        $message = "You have received $amount $currency from $payer ($payerTel) on your INYAMIBWA account at $time. Your new balance: $balance $currency. #$eventName Online";
        sendSMS($sender, $receiver, $message);
        if(!empty($receiver2)) {
            sendSMS($sender, $receiver2, $message);
        }
        
        return;
    }

    function sendSMSToManagerold($access, $currency, $event, $amount, $payer, $payerTel) {
        $time = date("Y-m-d H:i:s");
        $getTotal = $access->query("SELECT SUM(amount) as balance FROM tbl_pay_tickets WHERE event_id = '".$event."' AND paySts = 4 AND pay_mode = 1");
        $total = $getTotal->fetch();
        $balance = number_format($total['balance'], 0);
    
        // Send SMS
        $sender = getEventSMSName($access, $event);
        $receiver = getEventManagerPhone($access, $event);
        $receiver2 = getEventManagerPhone2($access, $event);
        $eventName = getEventName($access, $event);
        $message = "You have received $amount $currency from $payer ($payerTel) on your IBITARAMO account at $time. Your new balance: $balance $currency. #$eventName Online";
        sendSMS($sender, $receiver, $message);
        sendSMS($sender, $receiver2, $message);
        return;
    }
    
    function sendSMSToClient($access, $currency, $isSupport, $event, $ticket, $phone, $name) {
        $sender = getEventSMSName($access, $event);
        $receiver = $phone;
        $eventName = getEventName($access, $event);
        
        if($isSupport == 1){
            $message="Dear $name, thank you for your generous contribution towards our event, $eventName. Your support is greatly appreciated and will make a significant impact. We are honored to have your backing and look forward to sharing the success of the event with you.";
        }
        else{
            $encryptedTicket = encryptTicket($ticket);
            $link ="https://".str_replace('www.', '', $_SERVER['SERVER_NAME'])."/ticket?t=" . $encryptedTicket;
            $message = "Dear $name, Below you find the link for your e-ticket. Please download and save the ticket(s) on your phone or as a printout. you will need to present the attached ticket(s) when you arrive at the event venue. $link";
        }
        
        sendSMS($sender, $receiver, $message);
        return;
    }

    function sendEmailToClient($access, $currency, $ticket, $event, $email, $name) {
        $sender = 'ibitaramo';
        $attachment = generateAttachment($ticket, $access, $currency);
        $eventName = getEventName($access, $event);
        $call_center =  getSupportNumber($access, $event);
        $message = "Dear $name, Below you will find details of your ticket purchase and attached e-ticket. Please save the ticket(s) on your phone or as a printout. you will need to present the attached ticket(s) when you arrive at the event venue.";
        sendEmail($sender, $email, $message, $attachment, $eventName, $call_center);
        return;
    }
?>