<?php
    ob_start(); 
    ini_set('log_errors', 0);
    include '../../../config/connect.php';
    include '../../utils/functions.php';
    include('../../phpqrcode/qrlib.php');
    require('../../fpdf/fpdf.php');
    
    $eventId = $_REQUEST['ev'];
    $agentId = $_REQUEST['ag'];
    $planId = $_REQUEST['pl']; 
    
    $pdf=new FPDF();
    $pdf->addPage();
    $pdf->SetAuthor($sys);
    $pdf->SetTitle('Tickets');
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFillColor(255,255,255);
    $pdf->SetDrawColor(255, 255, 255);
    $pdf->SetLineWidth(0.01);
    $pdf->SetAutoPageBreak(false);
    
    try {
    
    $eventData = $db->query('SELECT * FROM tbl_events WHERE evt_id="'.$eventId.'"');  
    $event = $eventData->fetch();
    
    $getTickets = $conn->prepare('SELECT 
                                    c.con_tck_id, 
                                    c.con_token, 
                                    c.tcode, 
                                    c.price, 
                                    c.seat_no,
                                    c.seat_index,
                                    tp.ticket_file, 
                                    tp.price_plan,
                                    tp.seats,
                                    tp.seat_index AS seating,
                                    ev.evtname, 
                                    ev.event_desc,
                                    ev.start_date,
                                    o.owner_name 
                                FROM tbl_con_tickets c
                                    INNER JOIN tbl_ticket_price tp ON c.price_id = tp.price_id
                                    INNER JOIN tbl_events ev ON c.evt_id = ev.evt_id
                                    INNER JOIN tbl_event_owners o ON ev.owner_id = o.owner_id
                                WHERE 
                                    c.price_id = ? AND 
                                    c.evt_id = ? AND 
                                    c.agent_id = ? AND
                                    c.export = 0 AND 
                                    tp.post = 0 AND
                                    ev.disp = 1
                                ORDER BY c.con_tck_id ASC ');
    $getTickets->execute([$planId, $eventId, $agentId]);
    $ticketCount = $getTickets->rowCount();
    $x=0;
    $y=0;
    $c=0;    
    if($ticketCount > 0){
        while($ticket = $getTickets->fetch()){
            $eventName = $event['evtname'];
            $date = $event['start_date'];
            $support = $event['telSupp'];
            $door_open = $event['op_door'];
            
            $con_token = $ticket['con_token'];
            $tcode = $ticket['tcode'];
            $plan = $ticket['price_plan'];
            $ticket_file = $ticket['ticket_file'];
            $price = $ticket['price'];
            
            ##### MAIN #####
            
            $pdf->Image('../../../..'.$ticket_file, $x, $y, 210, 98);
            
            $pdf->SetFont('helvetica', 'B', 12);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+25);
            $pdf->cell(90, 5, strtoupper($eventName), 0, 0, 'L');

            $pdf->setXY($x+72, $y+30);
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->cell(30, 4, date("l, d M Y", strtotime($date)), 0, 0, 'L');
            
            $pdf->setXY($x+72, $y+40);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, 'Ticket ID:', 0);
            $pdf->SetFont('helvetica', '', 8); 
            $pdf->cell(15, 4, $tcode, 0, 0, 'L');
            $pdf->SetFont('helvetica', 'B', 8); 
            $pdf->cell(55, 4, 'Consignment', 0, 0, 'C');
            
            
            if($ticket['seating'] != $ticket['seats']){
                $pdf->Ln();
                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Table:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                $pdf->Ln();

                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Seat number:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_index'], 0, 0, 'L');
                $pdf->Ln();
            }
            else{
                $pdf->Ln(6);
                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Seat number:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                $pdf->Ln(); 
            }
            
            $pdf->setX($x+72);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, 'Category:', 0);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(25, 4, strtoupper($plan), 0, 0, 'L');
            $pdf->Ln();
            
            $pdf->setXY($x+107, $y+40);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(55, 4, '', 0, 0, 'C');
            $pdf->Ln();
            $pdf->setXY($x+120, $y+46);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(20, 4, 'Time:', 0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, date("H:i", strtotime($date)), 0, 0, 'L');
            $pdf->Ln();
            $pdf->setXY($x+120, $y+50);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(20, 4, 'Door Open:', 0, 0, 'L');
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, date("H:i", strtotime($door_open)), 0, 0, 'L');
            $pdf->Ln();

            $pdf->setXY($x+72, $y+58);
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->cell(40, 4, 'Price:', 0, 0, 'L');
            
            $pdf->SetFont('helvetica', 'B', 12);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+62);
            if($price != 0){
                $pdf->cell(40, 5, number_format($price).' '.$currency, 0, 0, 'L');
            } else{
                $pdf->cell(40, 5, 'N/A', 0, 0, 'L');
            }
            
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+62);
            $pdf->cell(90, 4, 'Support Line: '.$support, 0, 0, 'C');
            // $pdf->cell(16, 4, 'Powered by:', 0, 0, 'R');
            $pdf->SetFont('helvetica', 'B', 7);
            // $pdf->cell(20, 4, 'ITEC Ltd.', 0, 0, 'L');


            $pdf->setXY($x+72, $y+67);
            $pdf->cell(110, 7, 'Please make sure you Keep it in a safe place as duplicate tickets will not be issued.', 0, 0, 'C');
            
            ##### END MAIN #####
            
            ##### QR #####

            $qr_file = "QR/".$con_token.".png";
            QRcode::png($con_token, $qr_file, QR_ECLEVEL_Q, 10, 1);
            $pdf->Rect($x+167, $y+30, 25, 25, 'DF');
            $pdf->Image($qr_file, $x+168, $y+31, 23, 23);
            
            $pdf->setXY($x+167, $y+55);
            $pdf->SetFont('helvetica', '', 7);
            $pdf->cell(25, 4, 'Powered by ITEC Ltd.', 0, 0, 'C');
            
            unlink($qr_file);
            ##### END QR #####
            
            $y+=99;
            $c++;
            // $y>=290;
            if($y>=290 && $c<$ticketCount){
                $pdf->addPage();
                $x=0;
                $y=0;
            }
        }
        
        ############## Move out of inventory ########################
        $markAsExported = $conn->prepare('UPDATE tbl_con_tickets SET export = 1 WHERE price_id = ? AND evt_id = ? AND agent_id = ?');
        $markAsExported->execute([$planId, $eventId, $agentId]);
    } else{
        echo "Ticket already exported!";
    }
    
    $getTicketingData = $conn->prepare('SELECT
                                    DISTINCT(c.agent_id),
                                    tp.price_plan, 
                                    ev.evtname, 
                                    u.first_name 
                                FROM tbl_con_tickets c
                                    INNER JOIN tbl_ticket_price tp ON c.price_id = tp.price_id
                                    INNER JOIN tbl_events ev ON c.evt_id = ev.evt_id
                                    INNER JOIN tbl_users u ON c.agent_id = u.account_id
                                WHERE 
                                    c.price_id = ? AND 
                                    c.evt_id = ? AND 
                                    c.agent_id = ?
                                ');
    $getTicketingData->execute([$planId, $eventId, $agentId]);
    $data = $getTicketingData->fetch();
	$dname='Ticket_'.$data['evtname']."_".$data['price_plan']."_".$data['first_name'];
	$pdf->Output($dname.'.pdf','I');

    exit;
    }

//catch exception
catch(Exception $e) {
  echo 'Message: ' .$e->getMessage();
}
    ini_set('log_errors', 1);
    ob_end_flush();
?>