<?php
    include '../../config/connect.php';
    include '../utils/functions.php';
    
    $connection=$conn;
    class EventTicket{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	########################### Ticket Settings ##############################################
    	
    	public function saveTicketEntity($event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $ticket_file, $tick_icon){
            $stmt = $this->connect->prepare("INSERT INTO tbl_ticket_price(event_id, price_plan, price, tick_num, seats, seat_index, post, planDesc, ticket_file, tick_icon) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $ticket_file, $tick_icon]);
            return;
    	}
    	
    	public function updateTicketEntity($event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $price_id){
            $stmt = $this->connect->prepare("UPDATE tbl_ticket_price SET event_id = ?, price_plan = ?, price = ?, tick_num = ?, seats = ?, seat_index = ?, post = ?, planDesc = ? WHERE price_id = ?");
            $stmt->execute([$event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $price_id]);
            return;
    	}
    	
    	public function updateTicketFile($file, $price_id){
            $stmt = $this->connect->prepare("UPDATE tbl_ticket_price SET ticket_file = ? WHERE price_id = ?");
            $stmt->execute([$file, $price_id]);
            return;
    	}
    	
    	public function updateTicketIcon($file, $price_id){
            $stmt = $this->connect->prepare("UPDATE tbl_ticket_price SET tick_icon = ? WHERE price_id = ?");
            $stmt->execute([$file, $price_id]);
            return;
    	}
    	
        public function save_ticket(){
            $event_id = $_POST['event_id'];
            $price_plan = $_POST['price_plan'];
            $price = $_POST['price'];
            $tick_num = $_POST['tick_num'];
            $seats = $_POST['seats'];
            $seat_index = $_POST['seat_index'];
            $post = $_POST['post'];
            $planDesc = $_POST['planDesc'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE event_id = ? AND price_plan = ? AND post = ?");
            $stmt->execute([$event_id, $price_plan, $post]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Ticket Already exists!");
            }
            else{ 
                if(isset($_FILES['ticket_file'])){
                    $ticket_file = upload_ticket_file($_FILES['ticket_file']);
                }else{
                    $ticket_file = "/images/tickets/files/default.png";
                }
                
                if(isset($_FILES['tck_icon'])){
                    $tick_icon = upload_ticket_icon($_FILES['tck_icon']);
                }else{
                    $tick_icon = "/images/tickets/icons/ticket.svg";
                }

                $this->saveTicketEntity($event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $ticket_file, $tick_icon);
                sendFeedback(200, "Ticket created successfully!");
            }
    	}
    	
        public function get_ticket(){
        	$price_id = $_POST['price_id'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE price_id = ?");
            $stmt->execute([$price_id]);
            $data = $stmt->fetch();
            sendDataFeedback($data);
            return;
        }
                
        public function update_ticket(){
            $price_id = $_POST['price_id'];  
            $event_id = $_POST['event_id'];
            $price_plan = $_POST['price_plan'];
            $price = $_POST['price'];
            $tick_num = $_POST['tick_num'];
            $seats = $_POST['seats'];
            $seat_index = $_POST['seat_index'];
            $post = $_POST['post'];
            $planDesc = $_POST['planDesc'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE event_id = ? AND price_plan = ? AND post = ? AND price_id != ?");
            $stmt->execute([$event_id, $price_plan, $post, $price_id]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Ticket Already exists!");
            }
            else{
                $this->updateTicketEntity($event_id, $price_plan, $price, $tick_num, $seats, $seat_index, $post, $planDesc, $price_id);
                sendFeedback(200, "Ticket updated successfully!");
            }
        }
        
        public function update_ticket_files(){
            $price_id = $_POST['price_id'];  
            
            if(isset($_FILES['ticket_file'])){
                $file = upload_ticket_file($_FILES['ticket_file']);
                $this->updateTicketFile($file, $price_id);
            }
            
            if(isset($_FILES['tick_icon'])){
                $file = upload_ticket_icon($_FILES['tick_icon']);
                $this->updateTicketIcon($file, $price_id);
            }
        	
            sendFeedback(200, "Ticket updated successfully!");
        }
    
    	public function manage_ticket(){
            $price_id = $_POST['price_id'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE price_id = ?");
            $stmt->execute([$price_id]);
            $prevData=$stmt->fetch();
            if($prevData['status']==1){
                $status=2;
            }
            else{
                $status=1;
            }
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_ticket_price SET status = ? WHERE price_id = ?");
            if($stmt2->execute([$status, $price_id])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
    	
    	########################### Ticket Generation ##############################################
        
        public function get_ticket_with_agents(){
        	$price_id = $_POST['price_id'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE price_id = ?");
            $stmt->execute([$price_id]);
            $data = $stmt->fetch();

            $getGenerated = $this->connect->prepare("SELECT COUNT(con_tck_id) AS generated FROM tbl_con_tickets WHERE price_id = ?");
            $getGenerated->execute([$data['price_id']]);
            $generated = $getGenerated->fetch();
            
            $agents = array();
            $getEventUsers = $this->connect->prepare("SELECT users FROM tbl_events WHERE evt_id = ?");
            $getEventUsers->execute([$data['event_id']]);
            $eventUsers = $getEventUsers->fetch(); 
            
            $users = explode(',', trim($eventUsers['users'], '[]'));
            
            $placeholders = implode(",", $users);
            if(empty($placeholders)){
                $placeholders = 0;
            }
            
            $getEventAgents = $this->connect->prepare("
                                                SELECT
                                                        account_id,
                                                        first_name,
                                                        family_name
                                                    FROM tbl_users
                                                    WHERE account_id IN ($placeholders) AND role_id = 3 AND status = 1
                                                ");
            $getEventAgents->execute();
            $agents = $getEventAgents->fetchAll();

            $info = array();
            array_push($info, $data, $generated, $agents);
            $jsonData = json_encode($info);
            echo $jsonData;
        }
    	
    	public function verifyTicketGenerationRequest($event_id, $price_id, $tick_count, $agent_id){
            $stmt0 = $this->connect->prepare("SELECT * FROM tbl_events WHERE evt_id = ? AND JSON_CONTAINS(users, '\"" . $agent_id . "\"')");
            $stmt0->execute([$event_id]);
            if($stmt0->rowCount() == 0){
                return false;
            }
            
            $stmt = $this->connect->prepare("SELECT tick_num FROM tbl_ticket_price WHERE event_id = ? AND price_id = ?");
            $stmt->execute([$event_id, $price_id]);
            if($stmt->rowCount()>0){
                $ticket_data = $stmt->fetch();
                if($ticket_data['tick_num'] - $tick_count >= 0){
                    return true;
                }
                return false;
            }
            return false;
    	}
    	
    	public function getTicketSeats($price_id){
            $stmt = $this->connect->prepare("SELECT seats FROM tbl_ticket_price WHERE price_id = ?");
            $stmt->execute([$price_id]);
            $ticket_data = $stmt->fetch();
            return $ticket_data['seats'];
    	}
    	
    	public function getTicketSeatIndex($price_id){
            $stmt = $this->connect->prepare("SELECT seat_index FROM tbl_ticket_price WHERE price_id = ?");
            $stmt->execute([$price_id]);
            $ticket_data = $stmt->fetch();
            return $ticket_data['seat_index'];
    	}
    	
    	public function getEventPlan($price_id){
            $stmt = $this->connect->prepare("SELECT ev.start_date, tck.price FROM tbl_ticket_price tck INNER JOIN tbl_events ev ON tck.event_id = ev.evt_id WHERE tck.price_id = ?");
            $stmt->execute([$price_id]);
            $plan_data = $stmt->fetch();
            return $plan_data;
    	}
    	
    	public function getLastTicket(){
            $getLast = $this->connect->prepare('SELECT con_tck_id FROM tbl_con_tickets ORDER BY con_tck_id DESC LIMIT 1');
            $getLast->execute();
            if($getLast->rowCount() > 0){
                $last = $getLast->fetch();
                return $last['con_tck_id'];
            } else{
                return 0;
            }
    	}
    	
    	public function getLastSeat($price_id){
            $getLast = $this->connect->prepare("SELECT MAX(seat_no) AS last_seat FROM tbl_con_tickets WHERE price_id = ?");
            $getLast->execute([$price_id]);
            $last_seat = ($getLast->fetch())['last_seat'];
            return $last_seat;
    	}
    	
    	public function insertTickets($event_id, $price_id, $price, $ticket_code, $qr_token, $bkp_token, $seat_no, $seat_index, $agent_id){
            $stmt = $this->connect->prepare("INSERT INTO tbl_con_tickets(tcode, seat_no, seat_index, con_token, bkp_token, evt_id, agent_id, price_id, price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$ticket_code, $seat_no, $seat_index, $qr_token, $bkp_token, $event_id, $agent_id, $price_id, $price]);
            return;
    	}
    	
    	public function generateAndSaveTickets($event_id, $price_id, $tick_count, $agent_id){
            $seats = $this->getTicketSeats($price_id);
            $seat_index = $this->getTicketSeatIndex($price_id);
            $plan_data = $this->getEventPlan($price_id);
            $event_date = date($plan_data['start_date']);
            $price = $plan_data['price'];
            $prefix = date('dny', strtotime($event_date));
            
            try{    
        	    $this->connect->beginTransaction();
        	    $i = 1;
        	    if($seat_index == 1){
                    while($i <= $tick_count){
                        $seat_no = $this->getLastSeat($price_id);
                        $seat_no += 1;
                        $seat = 1;
                        
                        for($index = 1; $index <= $seats; $index++){
                            $last_ticket = $this->getLastTicket();
                            $last_ticket += 1;
                            
                            $ticket_code = $prefix.$last_ticket;
                            
                            $qr_token= hash('sha256', $last_ticket.$prefix.$price.$ticket_code);
                            $bkp_token = hash('sha256', $last_ticket.$prefix.$price);
                            
                            $this->insertTickets($event_id, $price_id, $price, $ticket_code, $qr_token, $bkp_token, $seat_no, $seat, $agent_id);
                            $seat += 1;
                        }
                        $i += 1;
                    }
                } else{
                    $seats = $seats * $seat_index;
                    while($i <= $tick_count){
                        $seat_no = $this->getLastSeat($price_id);
                        $seat_no += 1;
                        $seat = 1;

                        for($index = 1; $index <= $seats; $index++){
                            $last_ticket = $this->getLastTicket();
                            $last_ticket += 1;
                            
                            $ticket_code = $prefix.$last_ticket;
                            
                            $qr_token= hash('sha256', $ticket_code);
                            $bkp_token = hash('sha256', $last_ticket.$prefix.$price);
                            
                            $this->insertTickets($event_id, $price_id, $price, $ticket_code, $qr_token, $bkp_token, $seat_no, $seat, $agent_id);
                            $seat += 1;
                            $i += 1;
                        }
                        
                    }
                }
        	    if($this->connect->commit()){
                    sendFeedBack(200, "Tickets generated successfully!");
        	    }
        	    else {
        	        sendFeedBack(400, "Failed to generate tickets!");
        	    }
    	    }catch (PDOException $e) {
                $this->connect->rollback();
                sendFeedBack(400, "Something Went wrong, retry!"); 
            }
    	}
        
        public function generate_tickets(){
            $event_id = $_POST['event_id'];
            $price_id = $_POST['price_id'];
            $agent_id = $_POST['agent_id'];
            $tick_count = $_POST['tick_count'];
            
            $isValid = $this->verifyTicketGenerationRequest($event_id, $price_id, $tick_count, $agent_id);
            
            if($isValid){
                $this->generateAndSaveTickets($event_id, $price_id, $tick_count, $agent_id);
            } else{
                sendFeedback(400, "Invalid Request!");
            }
        }
    }
    
	$ticket = new EventTicket();
    $action = $_POST['action'];
	switch($action){
	    
	    ####### Settings #######
	    case 'register':
	        $ticket->save_ticket();
	        break;
	    case 'update':
	        $ticket->update_ticket();
	        break;
	    case 'getoedit':
	        $ticket->get_ticket();
	        break;
	    case 'manage':
	        $ticket->manage_ticket();
	        break;
	    case 'update_file':
	        $ticket->update_ticket_files();
	        break;
	        
	   ####### Generate #######
	   case 'getogenerate':
	        $ticket->get_ticket_with_agents();
	        break;
	   case 'generate':
	        $ticket->generate_tickets();
	        break;
	}

?>