<?php
    include '../../config/connect.php';
    include '../utils/functions.php';
    $connection=$conn;
    class OwnerKey{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function saveOwnerKeyEntity($owner_id, $mode_id, $ipay_key){
            $stmt = $this->connect->prepare("INSERT INTO tbl_owner_keys(owner_id, mode_id, ipay_key) VALUES (?, ?, ?)");
            $stmt->execute([$owner_id, $mode_id, $ipay_key]);
            return;
    	}
    	
    	public function updateOwnerKeyEntity($owner_id, $mode_id, $ipay_key, $kid){
            $stmt = $this->connect->prepare("UPDATE tbl_owner_keys SET owner_id = ?, mode_id = ?, ipay_key = ? WHERE key_id = ?");
            $stmt->execute([$owner_id, $mode_id, $ipay_key, $kid]);
            return;
    	}
    	
        public function save_OwnerKey(){
            $mode_id = $_POST['mode_id'];
            $owner_id = $_POST['owner_id'];
            $ipay_key = $_POST['ipay_key'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_owner_keys WHERE owner_id = ? AND mode_id = ?");
            $stmt->execute([$owner_id, $mode_id]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Key Already exists!");
            }
            else{ 
                $this->saveOwnerKeyEntity($owner_id, $mode_id, $ipay_key);
                sendFeedback(200, "Key created successfully!");
            }
    	}
    	
        public function view_OwnerKey(){
        	$kid = $_POST['kid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_owner_keys WHERE key_id = ?");
            $stmt->execute([$kid]);
            $data = $stmt->fetch();
            
            sendDataFeedback($data);
            return;
        }
                
        public function update_OwnerKey(){
            $kid = $_POST['kid'];    
            $mode_id = $_POST['mode_id'];
            $owner_id = $_POST['owner_id'];
            $ipay_key = $_POST['ipay_key'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_owner_keys WHERE owner_id = ? AND mode_id = ? AND key_id != ?");
            $stmt->execute([$owner_id, $mode_id, $kid]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Key Already exists!");
            }
            else{ 
                $this->updateOwnerKeyEntity($owner_id, $mode_id, $ipay_key, $kid);
                sendFeedback(200, "Key updated successfully!");
            }
        }
    
    	public function manage_OwnerKey(){
            $kid = $_POST['kid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_owner_keys WHERE key_id = ?");
            $stmt->execute([$kid]);
            $prevData=$stmt->fetch();
            if($prevData['status']==1){
                $status=2;
            }
            else{
                $status=1;
            }
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_owner_keys SET status = ? WHERE key_id = ?");
            if($stmt2->execute([$status, $kid])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
    }	
    
	$OwnerKey=new OwnerKey();
    $action = $_POST['action'];
	switch($action){
	    case 'register':
	        $OwnerKey->save_OwnerKey();
	        break;
	    case 'update':
	        $OwnerKey->update_OwnerKey();
	        break;
	    case 'view':
	        $OwnerKey->view_OwnerKey();
	        break;
	    case 'manage':
	        $OwnerKey->manage_OwnerKey();
	        break;
	}
?>

