<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
	function generateNames(max){
        const container = document.getElementById('name-container');
        container.innerHTML = '';
        for (let i = 1; i <= max; i++) {
            // Create the label element
            const label = document.createElement('label');
            label.className = 'col-form-label col-md-3';
            label.textContent = 'Name ' + i;
        
            // Create the input element
            const input = document.createElement('input');
            input.type = 'text';
            input.className = 'form-control';
            input.name = 'names[]';
        
            // Create the div element to hold both label and input
            const divContainer = document.createElement('div');
            divContainer.className = 'col-md-6 col-md-9';
        
            // Append the input to the div container
            divContainer.appendChild(input);
        
            // Append the div container to the main container
            container.appendChild(label);
            container.appendChild(divContainer);
        }
	}
	
    $(document).ready(function(){
        $("#event").change(function () {
            var formdata = {
                    event: $(this).val(),
                    action: 'get_plans_online'
                };
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#sender').attr('hidden', true);
            
            $.ajax({
                type: "POST",
                url: "/com/files/events/controller.php",
                data: formdata,
                dataType: "JSON",
                success: function (data) {
                    $('#spinner').fadeOut('fast');
                    $("#plan").empty();
                    $("#pay_mode").empty();

                    if(data[0].length>0){
                        $.each(data[0], function (index, value) {
                            $("#plan").append("<option value='" + value.price_id + "'>" + value.price_plan +" - " + value.price +"</option>");
                        });
                    }
                    $('#sender').removeAttr('hidden', true);
                },
                error:function(error){
                    $('#spinner').fadeOut('fast');
                    showInfoToast("Something went wrong!");
                }
            });
        });
        
        $("#sendTickets").submit(function(e){
            e.preventDefault();
            var formData = new FormData(this);
            var phone = $("#phone").val();
            swal({
                title: "Are you sure?",
                text: "You are going to send this ticket to "+phone+". This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $('#spinner0').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
                    $('#sender').attr('disabled', true);
                    $.ajax({
                        url: "/com/agent/support/controller.php",
                        type: "POST",
                        dataType: "JSON",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(data){
                            $('#spinner0').fadeOut('fast');
                            $('#sender').removeAttr('disabled');
                            if(data.status == 200){
                                showSuccessToast(data.message);
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner0').fadeOut('fast');
                            $('#sender').removeAttr('disabled');
                            showInfoToast("Something went wrong");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
</script>