<?php /** Author: @hicode **/ ?>
<?php include '../config/connect.php'; ?>
<?php ini_set('log_errors', 0); ?>
<?php
    $event = $_POST['event'];
?>
<h4 class="card-title"><i class="icon-sm fa fa-check-circle mr-2"></i>Event Analytics</h4>
<div class="row">
    <?php
        $query = "SELECT *,get_price_plan_balance(price_id) AS plan_balance FROM tbl_ticket_price WHERE event_id = ?";
        $plans = $conn->prepare($query);
        $plans->execute([$event]);
    
        while($plan = $plans->fetch()){
            $source = "online";
            if($plan['post'] == 0){
                $source = "hardC";
            }
            
            $allTickets = $conn->prepare("SELECT COUNT(con_tck_id) AS count FROM tbl_con_tickets WHERE price_id = ?");
            $allTickets->execute([$plan['price_id']]);
            $tickets = $allTickets->fetch()['count'] / $plan['seats'];
            
            $salesData = $conn->prepare("SELECT  
                                            COUNT(p.con_tck) AS sold_count, 
                                            COALESCE(SUM(p.amount), 0) AS amount 
                                        FROM tbl_pay_tickets p
                                            LEFT JOIN tbl_con_tickets c ON p.con_tck = c.con_tck_id
                                        WHERE p.event_id = ? AND c.price_id = ?");
            $salesData->execute([$event, $plan['price_id']]);
            
            $salesData = $salesData->fetch();
            $sales = $salesData['sold_count'] / $plan['seats'];
            $revenue = $salesData['amount'];
            $revenue = $plan['plan_balance'];
            // $revenue = $plan['price'] * $sales;

            $scannedTickets = $conn->prepare("SELECT COUNT(con_tck_id) AS count FROM tbl_con_tickets WHERE price_id = ? AND tck_status = 5");
            $scannedTickets->execute([$plan['price_id']]);
            $scanned = $scannedTickets->fetch()['count'] / $plan['seats'];

            $scanned_revenue = $plan['price'] * $scanned;

            

            
    ?>
    <div class="col-md-4 grid-margin stretch-card">
        <div class="card">
            <div class="card-body d-flex flex-column">
                <h4 class="card-title"> <i class="fas fa-tachometer-alt"></i> <?php echo $plan['price_plan']; ?> ||  <?php echo number_format($plan['price']); ?> FRW</h4>
                <div class="flex-grow-1 d-flex flex-column justify-content-between">
                <div class="pt-4">
                    <div id="sales-status-chart-legend" class="sales-status-chart-legend">
                        <ul class="legend2">
                            <li>
                                <span class="legend-label" style="background-color:#ff5e6d"></span><?php echo $source; ?>
                            </li> 
                            <li>
                                <span class="legend-label" style="background-color:#392c70"></span>All tickets<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($tickets); ?></label>
                            </li>
                            <?php 
                                if($source != "hardC"){
                            ?>
                                    <li>
                                        <span class="legend-label" style="background-color:#04b76b"></span>Sold<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($sales); ?></label>
                                    </li>
                                    <li>
                                        <span class="legend-label" style="background-color:#0b94f7"></span>Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($revenue)." ".$currency; ?></label>
                                    </li>
                            <?php }else { ?>
                                <!-- all tickets revenue -->
                                <li>
                                    <span class="legend-label" style="background-color:#392c70"></span>All tickets Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($tickets * $plan['price'])." ".$currency; ?></label>
                                </li>
                            <?php } ?>
                            <li>
                                <span class="legend-label" style="background-color:#eeeeee"></span>Scanned<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($scanned); ?></label>
                            </li>
                            <?php 
                                if($source == "hardC"){
                                    $returnedTickets = $conn->prepare("SELECT COUNT(con_tck_id) AS count FROM tbl_con_tickets WHERE price_id = ? AND tck_status = 6");
                                    $returnedTickets->execute([$plan['price_id']]);
                                    $rett = $returnedTickets->fetch()['count'] / $plan['seats'];

                                    $scanned_revenue = $plan['price'] * $scanned;
                                    $returned_revenue = $plan['price'] * $rett;
                                    $missing_revenue = $plan['price'] * ($tickets - $scanned - $rett);
                            ?>
                            <!-- scanned revenue -->
                            <li>
                                <span class="legend-label" style="background-color:#eeeeee"></span>Scanned Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($scanned_revenue)." ".$currency; ?></label>
                            </li>

                            <li>
                                <span class="legend-label" style="background-color:#ff0000"></span>Returned<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($rett); ?></label>
                            </li>
                            <!-- returned revenue -->
                            <li>
                                <span class="legend-label" style="background-color:#ff0000"></span>Returned Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($returned_revenue)." ".$currency; ?></label>
                            </li>
                            <li>
                                <span class="legend-label" style="background-color:#0000ff"></span>Missing<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($tickets - $scanned - $rett); ?></label>
                            </li>
                            <!-- missing revenue -->
                            <li>
                                <span class="legend-label" style="background-color:#0000ff"></span>Missing Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($missing_revenue)." ".$currency; ?></label>
                            </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>