<?php 
    session_start();
    include '../com/config/connect.php';  
    include '../com/files/utils/functions.php';
    
    $connection=$conn;
    class Auth{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function sendFeedback($status, $end, $message){
            $data = array("status" => $status, "message" => $message);
            $jsonData = json_encode($data);
            echo $jsonData; 
    	}
    	
        public function updateLog($account, $ip, $time){
            $stmt = $this->connect->prepare("UPDATE tbl_users SET last_login = ?, last_ip_address = ? WHERE account_id = ?");
              
            try {
                $stmt->execute([$time, $ip, $account]);
            } catch (PDOException $ex) {
                
            }
        }
        
        public function resetPass($user){
            $pwd = rand(1000000, 1999999);
            $password = password_hash($pwd, PASSWORD_DEFAULT);
            $stmt = $this->connect->prepare("UPDATE tbl_users SET account_passwd = ? WHERE account_id = ?");
            $stmt->execute([$password, $user]);
            return $pwd;
        }
        public function Authenticate(){
            $username = isset($_POST['username'])?$_POST['username']:'400_invalid_400_invalid';
            $passcode  = isset($_POST['passcode'])?$_POST['passcode']:'400_invalid_400_invalid';
        	$time = date("Y-m-d H:i:s", strtotime('+ 2hours'));
            $ip_address = $_SERVER['REMOTE_ADDR'];
        
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE account_name = ? AND status = 1");
            $stmt->execute([$username]);
            if($stmt->rowCount() != 0){
                $user = $stmt->fetch();
                if($user['account_passwd'] != NULL){
                    if (password_verify($passcode, $user['account_passwd'])){
                        $_SESSION['account'] = $user['account_id'];
                         $_SESSION['Identification'] = $user['Identification'];
                        $this->updateLog($user['account_id'], $ip_address, $time);
                        $this->sendFeedback(200, 1, "Connecting...");
                    }
                    else{
                        $this->sendFeedback(400, 0, "Incorrect password!");
                    }
                }
                else{
                    $this->sendFeedback(400, 0, "Invalid account!");
                }
            }
            else {
                $this->sendFeedback(400, 0, "Incorrect credentials!");
            }
        }
        
        function ResetPassword(){
    		global $sys;
    		global $syslink;
            $username = isset($_POST['username'])?$_POST['username']:'400_invalid_400_invalid';
        
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE (account_name = ? OR email = ?) AND status = 1");
            $stmt->execute([$username, $username]);
            if($stmt->rowCount() != 0){
                $user = $stmt->fetch();
                
                $first_name = $user['first_name'];
                $phone = $user['account_name'];
                $pwd = $this->resetPass($user['account_id']);
                
                $message="Dear $first_name, your account has been reset successfuly! Username: $phone | Password: $pwd. Click $syslink to open.";
        
                sendSMS($sys, $phone, $message);
                $this->sendFeedback(200, 1, "New password sent!");
            }
            else {
                $this->sendFeedback(400, 0, "Unknown account!");
            }
        }
        
    }
    
	$auth = new Auth();
    $action = $_POST['action'];
	switch($action){
	    case 'auth':
	        $auth->Authenticate();
	        break;
	    case 'reset':
	        $auth->ResetPassword();
	        break;
	}
?>