<?php 
    ob_start(); 
    ini_set('log_errors', 1);
    include('com/files/phpqrcode/qrlib.php');
    require('com/files/fpdf/fpdf.php');
    require('com/files/utils/functions.php');
    require('com/config/connect.php');
    
    function decryptURL($tickets) {
        $encryptedData = $tickets;
        $decodedData = urldecode($encryptedData);
        $json = base64_decode($decodedData);
        $decrypted = json_decode($json, true);
        return $decrypted;
    }

    $queryString = $_SERVER['QUERY_STRING'];
    $tID = substr($queryString, 2);
    $ticketIds=decryptURL($tID);
    $tckCount = count($ticketIds);
    
    $pdf=new FPDF();
    $pdf->AliasNbPages();
    
    $pdf->SetAuthor('ITEC');
    $pdf->SetTitle('Ticket');
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFillColor(255,255,255);
    $pdf->SetDrawColor(255, 255, 255);
    $pdf->SetLineWidth(0.01);
    $pdf->SetAutoPageBreak(false);
    
    $x = 0;
    $y = 0;
    $c = 0;

    foreach($ticketIds as $ticketId){
        $pdf->AddPage('L', [210, 98]);
        $conTick = $db->query('SELECT c.*, 
                                        t.price_plan, 
                                        t.ticket_file,
                                        t.seats,
                                        t.seat_index AS seating,
                                        pay.usNames,
                                        pay.pay_4ne,
                                        pay.trm_time
                                        FROM tbl_con_tickets c
                                            INNER JOIN tbl_ticket_price t ON c.price_id = t.price_id
                                            INNER JOIN tbl_pay_tickets pay ON c.con_tck_id = pay.con_tck
                                        WHERE c.con_tck_id="'.$ticketId.'" AND c.tck_status=4
                                    ');
        $CountTckNum = $conTick->rowCount();
        if($CountTckNum>0){
            $ticket = $conTick->fetch();
            $eventData = $db->query('SELECT * FROM tbl_events WHERE evt_id="'.$ticket['evt_id'].'"');
            $event = $eventData->fetch();
            
            $eventName = $event['evtname'];
            $date = $event['start_date'];
            $support = $event['telSupp'];
            $door_open = $event['op_door'];
            
            $con_token = $ticket['con_token'];
            $tcode = $ticket['tcode'];
            $plan = $ticket['price_plan'];
            $ticket_file = $ticket['ticket_file'];
            $price = $ticket['price'];
            $owner = $ticket['usNames'];
            $owner_phone = $ticket['pay_4ne'];  
            
            $purchased = date("l, d M Y, H:i", strtotime($ticket['trm_time'] . ' +1 hour'));
            
            ##### MAIN #####
            
            $pdf->Image('.'.$ticket_file, $x, $y, 210, 98);
            
            $pdf->SetFont('helvetica', 'B', 12);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+25);
            $pdf->cell(90, 5, strtoupper($eventName), 0, 0, 'L');

            $pdf->setXY($x+72, $y+30);
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->cell(30, 4, date("l, d M Y", strtotime($date)), 0, 0, 'L');
            
            $pdf->setXY($x+72, $y+40);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, 'Ticket ID:', 0);
            $pdf->SetFont('helvetica', '', 8); 
            $pdf->cell(15, 4, $tcode, 0, 0, 'L');
            
            if($ticket['seating'] != $ticket['seats']){
                $pdf->Ln();
                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Table:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                $pdf->Ln();

                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Seat number:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_index'], 0, 0, 'L');
                $pdf->Ln();
            }else{
                $pdf->Ln(6);
                $pdf->setX($x+72);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->cell(20, 4, 'Seat number:', 0);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->cell(25, 4, $ticket['seat_no'], 0, 0, 'L');
                $pdf->Ln(); 
            }
            
            $pdf->setX($x+72);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, 'Category:', 0);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(25, 4, strtoupper($plan), 0, 0, 'L');
            $pdf->Ln();
            
            $pdf->setXY($x+107, $y+40);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(55, 4, $owner, 0, 0, 'C');
            $pdf->Ln();
            $pdf->setXY($x+120, $y+46);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(20, 4, 'Time:', 0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, date("H:i", strtotime($date)), 0, 0, 'L');
            $pdf->Ln();
            $pdf->setXY($x+120, $y+50);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->cell(20, 4, 'Door Open:', 0, 0, 'L');
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->cell(20, 4, date("H:i", strtotime($door_open)), 0, 0, 'L');
            $pdf->Ln();

            $pdf->setXY($x+72, $y+58);
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->cell(40, 4, 'Price:', 0, 0, 'L');
            
            $pdf->SetFont('helvetica', 'B', 12);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+62);
            $pdf->cell(40, 5, number_format($price).' '.$currency, 0, 0, 'L');
            
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetTextColor(64, 64, 64);
            $pdf->setXY($x+72, $y+70);
            $pdf->cell(47, 4, 'Purchased: '.$purchased, 0, 0, 'L');
            $pdf->cell(43, 4, 'Support Line: '.$support, 0, 0, 'C');
            $pdf->cell(16, 4, 'Powered by:', 0, 0, 'R');
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->cell(14, 4, 'ITEC Ltd.', 0, 0, 'L');
            
            ##### END MAIN #####
            
            ##### QR #####

            $qr_file = "./com/files/tickets/export/QR/".$con_token.".png";
            QRcode::png($con_token, $qr_file, QR_ECLEVEL_Q, 10, 1);
            $pdf->Rect($x+167, $y+30, 25, 25, 'DF');
            $pdf->Image($qr_file, $x+168, $y+31, 23, 23);
            
            $pdf->setXY($x+167, $y+55);
            $pdf->SetFont('helvetica', '', 4);
            //$pdf->cell(25, 4, 'Powered By ITEC.', 0, 0, 'C');
            
            ##### END QR #####
        }
    }
	$doc_name = generatefile_v2();
	$pdf->Output($doc_name.'.pdf','I');

    exit;
    ob_end_flush();
?>