<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('.file').change(function(event) {
        var file = event.target.files[0];
        var maxSize = 4 * 1024 * 1024; // 2MB in bytes
        if (!file.type.match('image.*')) {
            showInfoToast('Please select an image file');
            return;
        } else if (file.size > maxSize) {
            showInfoToast('Image size exceeds 4MB. Please select a smaller image.');
            return;
        } else{
            return;
        }
    });
</script>
<script>
    function fetch_data(){
        $.ajax({
            url: "/com/files/tickets/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#tickets').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#tickets').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        
        $('#ticketRegistry').submit(function(e) {
            e.preventDefault();
            
            var formdata = new FormData(this);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Processing...");
            $('#ticketRegistry').attr('disabled',true);
            
            $.ajax({
                url: '/com/files/tickets/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#ticketRegistry').attr('disabled', false);
                    
                    if(data.status==200){
                        showSuccessToast(data.message);
                        setTimeout(function(){
                            window.location.reload();
                        }, 3000);
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#ticketRegistry').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                price_id : identifier,
                action : 'getoedit'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/tickets/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    
                    $("#price_id").val(data.price_id);
                    $("#price_plan").val(data.price_plan);
                    $("#price").val(data.price);
                    $("#tick_num").val(data.tick_num);
                    $("#seats").val(data.seats);
                    $("#seat_index").val(data.seat_index);
                    $("#planDesc").val(data.planDesc);
                    
                    var selectElement = document.getElementById('event_id');
                    var selectElement2 = document.getElementById('post');
                    
                    var selectedOption = selectElement.querySelector('option[value="' + data.event_id + '"]');
                    var selectedOption2 = selectElement2.querySelector('option[value="' + data.post + '"]');
                    
                    if(selectedOption){
                        selectedOption.selected = true;
                        selectElement.prepend(selectedOption);
                    }
                    
                    if(selectedOption2){
                        selectedOption2.selected = true;
                        selectElement2.prepend(selectedOption2);
                    }

                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $('#ticketUpdate').submit(function(e) {
            e.preventDefault();
            
            var formdata = new FormData(this);
            
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing...");
            $('#ticketUpdate').attr('disabled',true);
            $.ajax({
                url: '/com/files/tickets/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#ticketUpdate').attr('disabled', false);

                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#editModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#ticketUpdate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit ticket file retrieval
        $(document).on('click','#file',function(){
            var identifier = $(this).data('id');
            var formdata = {
                price_id : $("#price_id").val(),
                action : 'getoedit'
            };
            $("#file").prop("disabled", true);
            $('#spinner3').html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/tickets/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $("#editModal").modal('hide');
                    $("#file").prop("disabled", false);
                    $('#spinner3').hide();
                    
                    $("#f_price_id").val(data.price_id);
                    $("#ticket_file").attr('src', window.location.protocol+"//"+window.location.hostname +data.ticket_file);
                    $("#editFileModal").modal('show');
                },error: function(){
                    $('#spinner3').hide();
                    $("#file").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // update script
        $('#ticketFileUpdate').submit(function(e) {
            e.preventDefault();
            
            var formdata = new FormData(this);
            
            $('#spinner4').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator4').html("...");
            $('#ticketFileUpdate').attr('disabled',true);
            $.ajax({
                url: '/com/files/tickets/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner4').fadeOut('fast');
                    $('#indicator4').html("Save changes");
                    $('#ticketFileUpdate').attr('disabled', false);

                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#editFileModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner4').fadeOut('fast');
                    $('#indicator4').html("Save changes");
                    $('#ticketFileUpdate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // manage events
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                price_id : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/tickets/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
        
        
        // generate ticket retrieval
        $(document).on('click','.generate',function(){
            var identifier = $(this).data('id');
            var formdata = {
                price_id : identifier,
                action : 'getogenerate'
            };
            $("#file").prop("disabled", true);
            $('#spinner_gen_'+identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/tickets/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".generate").prop("disabled", false);
                    $('#spinner_gen_'+identifier).hide();
                    $("#gen_event_id").val(data[0].event_id);
                    $("#gen_price_id").val(data[0].price_id);
                    var remain  = data[0].tick_num - (data[1].generated/data[0].seats);
                    
                    $("#tick_count").attr('max', remain);
                    $("#tick_count").attr('min', 1);
                    $("#tick_count").val(remain);
                    $("#agent_id").empty();
                    if(data[2].length>0){
                        $.each(data[2], function (index, value) {
                            $("#agent_id").append("<option value='" + value.account_id + "'>" + value.first_name +' '+ value.family_name+"</option>");
                        });
                    }
                    if(remain==0){
                        showInfoToast("No remaining ticket!");
                    }else{
                        $("#maxima").html(remain);
                        $("#generateModal").modal('show');
                    }
                },error: function(){
                    $('#spinner_gen_'+identifier).hide();
                    $(".generate").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // ticket generate script
        $('#ticketGenerate').submit(function(e) {
            e.preventDefault();
            
            var formdata = new FormData(this);
            
            $('#spinner6').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator6').html("...");
            $('#ticketGenerate').attr('disabled',true);
            $.ajax({
                url: '/com/files/tickets/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner6').fadeOut('fast');
                    $('#indicator6').html("Save changes");
                    $('#ticketGenerate').attr('disabled', false);

                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#generateModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner6').fadeOut('fast');
                    $('#indicator6').html("Save changes");
                    $('#ticketGenerate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // generate ticket retrieval
        $(document).on('click','.merge',function(){
            var identifier = $(this).data('id');
            var formdata = {
                price_id : identifier,
                action : 'getomerge'
            };
            $('#spinner_gen_'+identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/tickets/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".generate").prop("disabled", false);
                    $('#spinner_gen_'+identifier).hide();
                    $("#gen_event_id").val(data[0].event_id);
                    $("#gen_price_id").val(data[0].price_id);
                    var remain  = data[0].tick_num - data[1].generated;
                    
                    $("#tick_count").attr('max', remain);
                    $("#tick_count").attr('min', 1);
                    $("#tick_count").val(remain);
                    $("#agent_id").empty();
                    if(data[2].length>0){
                        $.each(data[2], function (index, value) {
                            $("#agent_id").append("<option value='" + value.account_id + "'>" + value.first_name +' '+ value.family_name+"</option>");
                        });
                    }
                    if(remain==0){
                        showInfoToast("No remaining ticket!");
                    }else{
                        $("#maxima").html(remain);
                        $("#generateModal").modal('show');
                    }
                },error: function(){
                    $('#spinner_gen_'+identifier).hide();
                    $(".generate").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
    });
    
 </script>