<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function fetch_data(){
        $.ajax({
            url: "/com/files/okeys/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#okeys').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#okeys').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        $("#keyRegistry").submit(function(e){
            e.preventDefault();
            
            var formdata = new FormData(this);
            $("#keyRegistry :input").prop("disabled", true);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Processing");
            $.ajax({
                url: "/com/files/okeys/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    if(data.status==200){
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                    $("#keyRegistry :input").prop("disabled", false);
                },error: function(){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    $("#keyRegistry :input").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                kid : identifier,
                action : 'view'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/okeys/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#ipay_key").val(data.ipay_key);
                    $("#kid").val(data.key_id);

                    var selectElement = document.getElementById('owner_id');
                    var selectedOption = selectElement.querySelector('option[value="' + data.owner_id + '"]');

                    if(selectedOption){
                        selectedOption.selected = true;
                        selectElement.prepend(selectedOption);
                    }
                    
                    var selectElement2 = document.getElementById('mode_id');
                    var selectedOption2 = selectElement2.querySelector('option[value="' + data.mode_id + '"]');

                    if(selectedOption2){
                        selectedOption2.selected = true;
                        selectElement2.prepend(selectedOption2);
                    }
                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $("#keyUpdate").submit(function(e){
            e.preventDefault();
            var formdata = new FormData(this);
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing");
            $.ajax({
                url: "/com/files/okeys/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner2').hide();
                    $('#indicator2').html("Save changes");
                    if(data.status==200){
                        $("#editModal").modal('hide');
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },error: function(){
                    $('#spinner2').hide();
                    $('#indicator2').html("Register");
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // manage okeys
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                kid : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/okeys/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
    
 </script>