<?php include '../../config/connect.php'; ?>
<table id="key-listing" class="table d-table">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Event</th>
            <th>Date</th>
            <th>Users</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $stmt = $conn->prepare("SELECT * FROM tbl_events WHERE disp = 1 ORDER BY start_date ASC");
            $stmt->execute();
            $index = 1;
            while($row = $stmt->fetch()) {
                $users = explode(',', trim($row['users'], '[]'));
        ?>
        <tr>
            <td><?php echo $index++ ?></td>
            <td><?php echo $row['evtname']; ?></td>
            <td><?php echo $row['start_date']; ?></td>
            <td>
                <ol>
                <?php
                    $enabledUsers = $users;
                    $placeholders = implode(",", $enabledUsers);
                    if(empty($placeholders)){
                        $placeholders = 0;
                    }
                    
                    $getEventUsers = $conn->prepare("
                                                        SELECT
                                                                r.role,
                                                                u.first_name,
                                                                u.family_name
                                                            FROM tbl_users u 
                                                                INNER JOIN tbl_user_roles r ON u.role_id = r.role_id 
                                                            WHERE u.account_id IN ($placeholders) AND u.status = 1
                                                        ");
                    $getEventUsers->execute();
                    while($user = $getEventUsers->fetch()) {
                ?>
                <li><?php echo $user['first_name']." ".$user['family_name']; ?> | <code style="color: #04B76B; font-weight: 600;"><?php echo $user['role']; ?></code></li>
                <?php } ?>
                </ol>
            </td>
            <td>
                <div class="d-flex justify-content-between flex-nowrap">
                    <div class="btn badge badge-pill badge-outline-info edit" data-id="<?php echo $row['evt_id']; ?>"><span id="spinner_edit_<?php echo $row['evt_id']; ?>"></span><i class="fa fa-edit"></i></div>
                </div>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<script>
    $(document).ready(function(){
        $('.d-table').DataTable({
            paging: false
        });
    });
</script>