<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.11/cropper.min.js"></script>
<script>
    var cropper = new Cropper(document.getElementById('cropped-image'), {
        cropBoxResizable: false,
        crop: function(event) {
            $('#crop-x').val(event.detail.x);
            $('#crop-y').val(event.detail.y);
            $('#crop-width').val(event.detail.width);
            $('#crop-height').val(event.detail.height);
        }
    });

    $('#icon-file').change(function(event) {
        var file = event.target.files[0];
        var maxSize = 1 * 1024 * 1024; // 1MB in bytes
        if (!file.type.match('image.*')) {
            document.getElementById("crop-button").setAttribute('hidden',true);
            showInfoToast('Please select an image file');
            return;
        }
        else if (file.size > maxSize) {
            document.getElementById("crop-button").setAttribute('hidden', true);
            showInfoToast('Image size exceeds 1MB. Please select a smaller image.');
            return;
        }
        var reader = new FileReader();
        reader.onload = function(event) {
            document.getElementById("crop-button").removeAttribute('hidden');
            cropper.replace(event.target.result);
        }
        reader.readAsDataURL(file);
    });
    
    
    var cropper2 = new Cropper(document.getElementById('cropped-image-2'), {
        cropBoxResizable: false,
        crop: function(event) {
            $('#crop-x').val(event.detail.x);
            $('#crop-y').val(event.detail.y);
            $('#crop-width').val(event.detail.width);
            $('#crop-height').val(event.detail.height);
        }
    });
    
    $('#icon-file-2').change(function(event) {
        var file = event.target.files[0];
        var maxSize = 1 * 1024 * 1024; // 1MB in bytes
        if (!file.type.match('image.*')) {
            document.getElementById("crop-button-2").setAttribute('hidden',true);
            showInfoToast('Please select an image file');
            return;
        }
        else if (file.size > maxSize) {
            document.getElementById("crop-button-2").setAttribute('hidden', true);
            showInfoToast('Image size exceeds 1MB. Please select a smaller image.');
            return;
        }
        var reader = new FileReader();
        reader.onload = function(event) {
            document.getElementById("crop-button-2").removeAttribute('hidden');
            cropper2.replace(event.target.result);
        }
        reader.readAsDataURL(file);
    });
</script>
<script>
    function fetch_data(){
        $.ajax({
            url: "/com/files/evpay/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#evpay').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#evpay').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        
        $('#crop-button').on('click', function(event) {
            if($("#mode").val()===""){
                showInfoToast("Mode name should not be empty!");
                return;
            }
            
            var croppedImageDataURL = cropper.getCroppedCanvas().toDataURL();
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Uploading...");
            $('#crop-button').attr('disabled',true);
            $.ajax({
                url: '/com/files/evpay/controller.php',
                type: 'POST',
                data: {
                    action:'register',
                    mode_name: $('#mode').val(),
                    icon: croppedImageDataURL,
                    crop_x: $('#crop-x').val(),
                    crop_y: $('#crop-y').val(),
                    crop_width: $('#crop-width').val(),
                    crop_height: $('#crop-height').val()
                },
                dataType: 'JSON',
                success: function(data) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Crop & upload");
                    $('#crop-button').attr('disabled', false);
                    
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    if(data.status==200){
                         $('#crop-button').remove();
                        showSuccessToast(data.message);
                        setTimeout(function(){
                            window.location.reload();
                        }, 2000);
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Crop & upload");
                    $('#crop-button').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                pid : identifier,
                action : 'view'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/evpay/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#mode_name").val(data.mode_name);
                    $("#mode_icon").attr('src', data.icon);
                    $("#pid").val(data.mode_id);
                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
 
        // update script
        $('#crop-button-2').on('click', function(event) {
            if($("#mode_name").val()===""){
                showInfoToast("Mode name should not be empty!");
                return;
            }
            if(cropper2.getCroppedCanvas() != null){
                var croppedImageDataURL = cropper2.getCroppedCanvas().toDataURL();
            }else{
                var croppedImageDataURL = "";
            }
            
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Uploading...");
            $('#crop-button-2').attr('disabled',true);
            $.ajax({
                url: '/com/files/evpay/controller.php',
                type: 'POST',
                data: {
                    action:'update',
                    pid: $('#pid').val(),
                    mode_name: $('#mode_name').val(),
                    icon: croppedImageDataURL,
                    crop_x: $('#crop-x').val(),
                    crop_y: $('#crop-y').val(),
                    crop_width: $('#crop-width').val(),
                    crop_height: $('#crop-height').val()
                },
                dataType: 'JSON',
                success: function(data) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Crop & upload");
                    $('#crop-button-2').attr('disabled', false);
                    
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#editModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Crop & upload");
                    $('#crop-button-2').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        
        
        // manage pmodes
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                pid : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/evpay/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
    
 </script>