<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('.file').change(function(event) {
        var file = event.target.files[0];
        var maxSize = 3 * 1024 * 1024; // 3MB in bytes
        if (!file.type.match('image.*')) {
            $("#f-button").attr('disabled', true);
            showInfoToast('Please select an image file');
            return;
        }
        else if (file.size > maxSize) {
            $("#f-button").attr('disabled', true);
            showInfoToast('Image size exceeds 3MB. Please select a smaller image.');
            return;
        }else{
            $("#f-button").attr('disabled', false);
        }
    });
</script>
<script>
    function validatePhoneNumber(phone) {
        var pattern = /^07[89]\d{7}$/;
        if (pattern.test(phone.trim())) {
            return true;
        }else{
            return false;
        }
    }
    
    function cleanPhoneNumber(input) {
        var phoneNumber = input.value;
        var cleanedPhoneNumber = phoneNumber.replace(/[^+0-9]/g, "");
        input.value = cleanedPhoneNumber;
    } 
   
    function fetch_data(){
        $.ajax({
            url: "/com/files/events/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#events').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#events').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        
        $('#eventRegistry').submit(function(event) {
            event.preventDefault();
            if(!validatePhoneNumber($("#itelSupp").val()) || !validatePhoneNumber($("#itelMnge").val())){
                showInfoToast("Please enter a valid phone number starting with 078 or 079");
                return;
            }
            
            var formData = new FormData(this);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Saving...");
            $('#s-button').attr('disabled',true);
            $.ajax({
                url: '/com/files/events/controller.php',
                type: 'POST',
                data: formData,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#s-button').attr('disabled', false);
                    
                    if(data.status==200){
                        showSuccessToast(data.message);
                        setTimeout(function(){
                            window.location.reload();
                        }, 2000);
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#s-button').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                evt_id : identifier,
                action : 'getoedit'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/events/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#evt_id").val(data.evt_id);
                    $("#evtname").val(data.evtname);
                    $("#event_desc").val(data.event_desc);
                    $("#telMnge").val(data.telMnge);
                    $("#telSupp").val(data.telSupp);
                    $("#start_date").val(data.start_date);
                    $("#evtSMS").val(data.evtSMS);
                    $("#op_door").val(data.op_door);

                    var selectElement = document.getElementById('catg_id');
                    var selectElement2 = document.getElementById('owner_id');
                    var selectElement3 = document.getElementById('venue_id');
                    
                    var selectedOption = selectElement.querySelector('option[value="' + data.catg_id + '"]');
                    var selectedOption2 = selectElement2.querySelector('option[value="' + data.owner_id + '"]');
                    var selectedOption3 = selectElement3.querySelector('option[value="' + data.venue_id + '"]');
                    
                    if(selectedOption){
                        selectedOption.selected = true;
                        selectElement.prepend(selectedOption);
                    }
                    
                    if(selectedOption2){
                        selectedOption2.selected = true;
                        selectElement2.prepend(selectedOption2);
                    }

                    if(selectedOption3){
                        selectedOption3.selected = true;
                        selectElement3.prepend(selectedOption3);
                    }
                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.files',function(){
            var identifier = $(this).data('id');
            var formdata = {
                evt_id : identifier,
                action : 'getoedit'
            };
            $(".files").prop("disabled", true);
            $('#spinner_files_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/events/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".files").prop("disabled", false);
                    $('#spinner_files_' + identifier).hide();
                    $("#f_evt_id").val(data.evt_id);
                    $("#f_evtname").val(data.evtname);
                    
                    $("#fileModal").modal('show');
                },error: function(){
                    $('#spinner_files_' + identifier).hide();
                    $(".files").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $('#eventUpdate').submit(function(event) {
            event.preventDefault();
            if(!validatePhoneNumber($("#telSupp").val()) || !validatePhoneNumber($("#telMnge").val())){
                showInfoToast("Please enter a valid phone number starting with 078 or 079");
                return;
            }
            
            var formData = new FormData(this);
            
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Uploading...");
            $('#e-button').attr('disabled',true);
            $.ajax({
                url: '/com/files/events/controller.php',
                type: 'POST',
                data: formData,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#e-button').attr('disabled', false);

                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#editModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#e-button').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // files
        $('#eventFiles').submit(function(event) {
            event.preventDefault();
            $('#spinner3').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator3').html("Uploading...");
            
            var formData = new FormData(this);
            $('#f-button').attr('disabled',true);
            $.ajax({
                url: '/com/files/events/controller.php',
                type: 'POST',
                data: formData,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner3').fadeOut('fast');
                    $('#indicator3').html("Save changes");
                    $('#f-button').attr('disabled', false);
                    
                    if(data.status==200){
                        showSuccessToast(data.message);
                        setTimeout(function(){
                            window.location.reload();
                        }, 2000);
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner3').fadeOut('fast');
                    $('#indicator3').html("Save changes");
                    $('#f-button').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // manage events
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                evt_id : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/events/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
    
 </script>