<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function(){
        $("#event").change(function () {
            var formdata = {
                    event: $(this).val(),
                    action: 'get_plans_online'
                };
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $.ajax({
                type: "POST",
                url: "/com/files/events/controller.php",
                data: formdata,
                dataType: "JSON",
                success: function (data) {
                    $('#spinner').fadeOut('fast');
                    $("#plan").empty();

                    if(data[0].length>0){
                        $("#plan").append("<option>choose one...</option>");
                        $.each(data[0], function (index, value) {
                            $("#plan").append("<option value='" + value.price_id + "'>" + value.price_plan +" - " + value.price +"</option>");
                        });
                    }
                },
                error:function(error){
                    $('#spinner').fadeOut('fast');
                    showInfoToast("Something went wrong!");
                }
            });
        });
        
        $("#plan").change(function () {
            var formdata = {
                    event: $("#event").val(),
                    priceId: $(this).val(),
                    contact: $("#contact").val()
                };
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            
            $.ajax({
                type: "POST",
                url: "/com/agent/support/fetch_sold.php",
                data: formdata,
                success: function (data) {
                    $('#spinner2').fadeOut('fast');
                    $("#sold").html(data);
                    $(".table").DataTable({paging: false})
                },
                error:function(error){
                    $('#spinner2').fadeOut('fast');
                    showInfoToast("Something went wrong!");
                }
            });
        });
        
        $(document).on('click', '.send', function(){
            const identifier = $(this).data('id');
            var formData = {
                    action: 'resendticket',
                    data: $(this).data('href')
                };
            $('#spinner0_'+identifier).html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('.send').attr('disabled', true);
            $.ajax({
                url: "/com/agent/support/controller.php",
                type: "POST",
                dataType: "JSON",
                data: formData,
                success: function(data){
                    $('#spinner0_'+identifier).fadeOut('fast');
                    $('.send').removeAttr('disabled');
                    if(data.status == 200){
                        showSuccessToast(data.message);
                    }else{
                        showInfoToast(data.message);
                    }
                },error: function(){
                    $('#spinner0_'+identifier).fadeOut('fast');
                    $('.send').removeAttr('disabled');
                    showInfoToast("Something went wrong");
                }
            });
        });
    });
</script>