<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function validatePhoneNumber(phone) {
        var pattern = /^07[89]\d{7}$/;
        if (pattern.test(phone.trim())) {
            return true;
        }else{
            return false;
        }
    }
    
    function cleanPhoneNumber(input) {
        var phoneNumber = input.value;
        var cleanedPhoneNumber = phoneNumber.replace(/[^+0-9]/g, "");
        input.value = cleanedPhoneNumber;
    } 
   
    function fetch_data(){
        $.ajax({
            url: "/com/files/users/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#users').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#users').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        $("#userRegistry").submit(function(e){
            e.preventDefault();
            
            if(!validatePhoneNumber($("#user_phone").val())){
                showInfoToast("Please enter a valid phone number starting with 078 or 079");
                return;
            }  
            var formdata = new FormData(this);
            $("#userRegistry :input").prop("disabled", true);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Processing");
            $.ajax({
                url: "/com/files/users/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    if(data.status==200){
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                    $("#userRegistry :input").prop("disabled", false);
                },error: function(){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    $("#userRegistry :input").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                uid : identifier,
                action : 'view'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/users/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#first_name").val(data.first_name);
                    $("#family_name").val(data.family_name);
                    $("#email").val(data.email);
                    $("#phone").val(data.phone);
                    $("#uid").val(data.account_id);
                    var selectElement = document.getElementById('role_id');
                    var selectedOption = selectElement.querySelector('option[value="' + data.role_id + '"]');

                    if(selectedOption){
                        selectedOption.selected = true;
                        selectElement.prepend(selectedOption);
                    }
                    
                    var selectElement2 = document.getElementById('gender');
                    var selectedOption2 = selectElement2.querySelector('option[value="' + data.gender + '"]');

                    if(selectedOption2){
                        selectedOption2.selected = true;
                        selectElement2.prepend(selectedOption2);
                    }
                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $("#userUpdate").submit(function(e){
            e.preventDefault();
            var formdata = new FormData(this);
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing");
            $.ajax({
                url: "/com/files/users/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner2').hide();
                    $('#indicator2').html("Save changes");
                    if(data.status==200){
                        $("#editModal").modal('hide');
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },error: function(){
                    $('#spinner2').hide();
                    $('#indicator2').html("Register");
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // manage users
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                uid : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/users/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
    
 </script>