<div class="content-wrapper">
    <div class="page-header">
        <h3 class="page-title"><?php echo $title; ?></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="?access=home"><?php echo $sys; ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $title; ?></li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                        <a class="nav-link active" id="list-tab" data-toggle="tab" href="#list-1" role="tab" aria-controls="list-1" aria-selected="true">List</a>
                        </li>
                        <li class="nav-item">
                        <a class="nav-link" id="add-tab" data-toggle="tab" href="#add-1" role="tab" aria-controls="add-1" aria-selected="false">Add</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="list-1" role="tabpanel" aria-labelledby="list-tab">
                            <div class="table-responsive"  id="tickets">
                                <div class="loader-demo-box">
                                    <div class="bar-loader">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="add-1" role="tabpanel" aria-labelledby="add-tab">
                            <div class="grid-margin stretch-card">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title">Register new Ticket</h4>
                                        <form class="forms-sample" id="ticketRegistry" action="#" method="POST">
                                            <input type="hidden" name="action" value="register">
                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label>Event</label>
                                                    <select class="form-control" name="event_id" required>
                    									<?php
                    									    if($_SESSION['role_id'] == 1){
                    									        $query = "SELECT * FROM tbl_events WHERE disp = 1";
                    									    } else{
                    									        $query = "SELECT * FROM tbl_events WHERE disp = 1 AND owner_id = '".$_SESSION['account']."'";
                    									    }
                                        					$stmt = $conn->prepare($query);
                                        					$stmt->execute();
                                        					while ($row = $stmt->fetch()) { 
                                        				?>
                                                        <option value="<?php echo $row['evt_id']; ?>"><?php echo $row['evtname'];?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket Name <code>*</code></label>
                                                    <input type="text" class="form-control" name="price_plan" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket Price <code>*</code></label>
                                                    <input type="number" class="form-control" name="price" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket Count <code>* (0 for card copies)</code></label>
                                                    <input type="number" class="form-control" name="tick_num" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Seats Count <code>*</code></label>
                                                    <input type="number" class="form-control" name="seats" value="1" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Seats Indices <code>*</code></label>
                                                    <input type="number" class="form-control" name="seat_index" value="1" required>
                                                </div>
                                                <div class="col-md-12 form-group">
                                                    <label>Plan Description</label>
                                                    <textarea class="form-control" name="planDesc"  placeholder="Ticket plan description goes here"></textarea>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket Post <code>*</code></label>
                                                    <select class="form-control" name="post" required>
                                                        <option value="1">Online</option>
                                                        <option value="0">Hard Copy</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket File <code>*</code></label>
                                                    <input type="file" class="form-control file" name="ticket_file" accept="image/*">
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Ticket Icon</label>
                                                    <input type="file" class="form-control file" name="tick_icon" accept="image/*">
                                                </div>
                                            </div>
                                            <button type="submit" id="submit" class="btn btn-primary mr-2"><span id="spinner"></span>&nbsp;<span id="indicator">Save</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form class="forms-sample" id="ticketUpdate" action="" method="POST" autocomplete="off">
    <div class="modal fade " id="editModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ticket update</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="update">
                    <input type="hidden" name="price_id" id="price_id">
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>Event</label>
                            <select class="form-control" name="event_id" id="event_id" required>
								<?php
								    if($_SESSION['role_id'] == 1){
								        $query = "SELECT * FROM tbl_events WHERE disp = 1";
								    } else{
								        $query = "SELECT * FROM tbl_events WHERE disp = 1 AND owner_id = '".$_SESSION['account']."'";
								    }
                					$stmt = $conn->prepare($query);
                					$stmt->execute();
                					while ($row = $stmt->fetch()) { 
                				?>
                                <option value="<?php echo $row['evt_id']; ?>"><?php echo $row['evtname'];?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Ticket Name <code>*</code></label>
                            <input type="text" class="form-control" name="price_plan" id="price_plan" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Ticket Price <code>*</code></label>
                            <input type="number" class="form-control" name="price" id="price" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Ticket Count <code>*</code></label>
                            <input type="number" class="form-control" name="tick_num" id="tick_num" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Seats Count <code>*</code></label>
                            <input type="number" class="form-control" name="seats" id="seats" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Seats Indices <code>*</code></label>
                            <input type="number" class="form-control" name="seat_index" id="seat_index" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Plan Description</label>
                            <textarea class="form-control" name="planDesc" id="planDesc"  placeholder="Ticket plan description goes here"></textarea>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Ticket Post <code>*</code></label>
                            <select class="form-control" name="post" id="post" required>
                                <option value="1">Online</option>
                                <option value="0">Hard Copy</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><span id="spinner2"></span>&nbsp;<span id="indicator2">Save changes</span></button>
                    <button type="button" class="btn btn-light" id="file"><span id="spinner3"></span>&nbsp;<span id="indicator3">files</span></button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!--generate-->
<form class="forms-sample" id="ticketGenerate" action="" method="POST" autocomplete="off">
    <div class="modal fade " id="generateModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ticket Generate</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="generate">
                    <input type="hidden" name="event_id" id="gen_event_id">
                    <input type="hidden" name="price_id" id="gen_price_id">
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>Ticket Count <code>(max = <span id="maxima"></span> tickets)</code></label>
                            <input type="number" class="form-control" name="tick_count" id="tick_count" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Agent</label>
                            <select class="form-control" name="agent_id" id="agent_id" required>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><span id="spinner6"></span>&nbsp;<span id="indicator6">Generate</span></button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!--Merge-->
<form class="forms-sample" id="ticketMerge" action="" method="POST" autocomplete="off">
    <div class="modal fade " id="mergeModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ticket Merger</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="merge">
                    <input type="hidden" name="event_id" id="merg_event_id">
                    <input type="hidden" name="old_price_id" id="old_price_id">
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>Merge To</label>
                            <select class="form-control" name="new_price_id" id="new_price_id" required>
                            </select>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Ticket Count <code>(max = <span id="merg_maxima"></span> tickets)</code></label>
                            <input type="number" class="form-control" name="tick_count" id="merg_tick_count" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Agent</label>
                            <select class="form-control" name="agent_id" id="merg_agent_id" required>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><span id="spinner8"></span>&nbsp;<span id="indicator8">Generate</span></button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!--ticket files-->
<form class="forms-sample" id="ticketFileUpdate" action="" method="POST" autocomplete="off">
    <div class="modal fade " id="editFileModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_file">
                    <input type="hidden" name="price_id" id="f_price_id">
                    <center>
                        <img src="" id="ticket_file"  alt="" width="100%" height="200px" class="page-header">
                    </center>
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>Ticket File <code>*</code></label>
                            <input type="file" class="form-control file" name="ticket_file" accept="image/*">
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Ticket Icon <code>*</code></label>
                            <input type="file" class="form-control file" name="tick_icon" accept="image/*">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><span id="spinner4"></span>&nbsp;<span id="indicator4">Save changes</span></button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!--ticket icon-->

<?php include '../files/tickets/scripts.php' ?>