<?php /** Author: @hicode **/ ?>
<?php
    ini_set('log_errors', 0);
    include '../../config/connect.php';
    include '../utils/communication.php';
    include('../phpqrcode/qrlib.php');
    require('../fpdf/fpdf.php');
    $connection=$conn;
    class Ticket{
        private $connect;
        public function __construct() {
    		global $connection;
    		global $currency;
    		$this->connect=$connection;
    		$this->currency=$currency;
    	}

        public function createRef($con_tck){
            $req_ref = substr(uniqid(), 0, 7);
            $req_ref = $con_tck . "" . $req_ref;
            return $req_ref;
        }
    	
        public function getPlanSeats($plan){
            $getPlanSeats = $this->connect->prepare("SELECT seats FROM tbl_ticket_price WHERE price_id = ?");
            $getPlanSeats->execute([$plan]);
            $pseats = $getPlanSeats->fetch();
            return $pseats['seats'];
        }
        
        public function getPlanAmount($plan){
            $getPlanAmt = $this->connect->prepare("SELECT price FROM tbl_ticket_price WHERE price_id = ?");
            $getPlanAmt->execute([$plan]);
            $price = $getPlanAmt->fetch()['price'];
            return $price;
        }
    	
        public function insertPayTicket($ticket, $uniqueId, $amount, $names, $phone, $email, $payMode, $ev) {
            $ref = $this->createRef($ticket);
            $sql = $this->connect->prepare("INSERT INTO tbl_pay_tickets(con_tck, req_ref, ptransid, amount, usNames, pay_4ne, usMail, paySts, post, pay_mode, event_id) VALUES (?, ?, ?, ?, ?, ?, ?, 4, 1, ?, ?)");
            $sql->execute([$ticket, $ref, $uniqueId, $amount, $names, $phone, $email, $payMode, $ev]);
            return;
        }
    
        public function updateConTicket($ticket) {
            $sql = $this->connect->prepare("UPDATE tbl_con_tickets SET tck_status = 4 WHERE con_tck_id = ?");
            $sql->execute([$ticket]);
            return $ticket;
        }

        public function send_tickets(){
            $event = $_POST['event'];
            $plan = $_POST['plan'];
            $tcount = $_POST['tcounter'];
            $phone = $_POST['phone'];
            $email = $_POST['email'];
            $payMode = $_POST['pay_mode'];
            $date = date('Y-m-d');
            $timestamp = date("Y-m-d H:i:s");
            
            $tck_owners = array();
            
            foreach ($_POST['names'] as $name){
                array_push($tck_owners, $name);
            }
            
            $amount = $this->getPlanAmount($plan);
            $seats = $this->getPlanSeats($plan);
            $countert = $seats*$tcount;
            
            $famount = $amount/$seats;
            $amount = $amount*$tcount;
            $checkTickets = $this->connect->prepare('SELECT con_tck_id FROM tbl_con_tickets WHERE price_id = ? AND tck_status = 3 ORDER BY con_tck_id ASC LIMIT '.$countert);
            $checkTickets->execute([$plan]);
            if ($checkTickets->rowCount() > 0) {
                $tickets = array();
                $counter = 0;
                while($ticket = $checkTickets->fetch()){
                    $con_tck_id = $ticket['con_tck_id'];
                    array_push($tickets, $con_tck_id);
                    $uniqueId = $this->createRef($con_tck_id);
                    $usNames = $tck_owners[$counter]?$tck_owners[$counter]:$tck_owners[0];
                    $this->insertPayTicket($con_tck_id, $uniqueId, $famount, $usNames, $phone, $email, $payMode, $event);
                    $this->updateConTicket($con_tck_id);
                    $counter += 1;
                }
                
                sendSMSToClient($this->connect, $this->currency, 0, $event, $tickets, $phone, $tck_owners[0]);
                sendEmailToClient($this->connect, $this->currency, $tickets, $event, $email, $tck_owners[0]);
                sendSMSToManager($this->connect, $this->currency, $event, $amount, $tck_owners[0], $phone);
                sendFeedback(200, "All done, tickets sent!");
            }
            else{
                sendFeedback(400, "No tickets available!");
            }
        }
        
        function resend_tickets(){
            $contact = $_POST['contact'];
            $event = $_POST['data'][0];
            $plan = $_POST['data'][1];
            $seat_no = $_POST['data'][2];

            $checkTickets = $this->connect->prepare("
                                                    SELECT 
                                                            p.* 
                                                        FROM tbl_pay_tickets p 
                                                            INNER JOIN tbl_con_tickets ct ON p.con_tck = ct.con_tck_id
                                                        WHERE 
                                                            p.event_id = ? AND
                                                            ct.price_id = ? AND 
                                                            ct.seat_no = ? AND
                                                            (p.pay_4ne = ? OR p.usMail = ?)
                                                    ");

            $checkTickets->execute([$event, $plan, $seat_no, $contact, $contact]);
            if ($checkTickets->rowCount() > 0) {
                $tickets = array();
                $tck_owners  =array();
                $counter = 0;
                while($ticket = $checkTickets->fetch()){
                    $con_tck = $ticket['con_tck'];
                    array_push($tickets, $con_tck);
                    array_push($tck_owners, $ticket['usNames']);
                }
                if (filter_var($contact, FILTER_VALIDATE_EMAIL)){
                    sendEmailToClient($this->connect, $this->currency, $tickets, $event, $contact, $tck_owners[0]);
                }else{
                    sendSMSToClient($this->connect, $this->currency, 0, $event, $tickets, $contact, $tck_owners[0]);
                }
                
                sendFeedback(200, "All done, tickets sent!");
            }
            else{
                sendFeedback(400, "No tickets available!");
            }
        }
    }

    
	$ticket = new Ticket();
    $action = $_POST['action'];
	switch($action){
	    case 'sendticket':
	        $ticket->send_tickets();
	        break;
	    case 'resendticket':
	        $ticket->resend_tickets();
	        break;
	}

?>

