<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('.file').change(function(event) {
        var file = event.target.files[0];
        var maxSize = 2 * 1024 * 1024; // 2MB in bytes
        if (!file.type.match('image.*')) {
            showInfoToast('Please select an image file');
            return;
        } else if (file.size > maxSize) {
            showInfoToast('Image size exceeds 2MB. Please select a smaller image.');
            return;
        } else {
            return;
        }
    });
</script>
<script>
    function fetch_data() {
        $.ajax({
            url: "/com/files/adverts/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data) {
                $(".loader-demo-box").remove();
                $('#adverts').html(data);
            },
            error: function() {
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#adverts').hide();
            }
        });
    }

    $(document).ready(function() {
        fetch_data();

        $('#adRegistry').submit(function(e) {
            e.preventDefault();

            var formdata = new FormData(this);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Processing...");
            $('#adRegistry').attr('disabled', true);

            $.ajax({
                url: '/com/files/adverts/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#adRegistry').attr('disabled', false);

                    if (data.status == 200) {
                        showSuccessToast(data.message);
                        setTimeout(function() {
                            window.location.reload();
                        }, 3000);
                    } else {
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner').fadeOut('fast');
                    $('#indicator').html("Save");
                    $('#adRegistry').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // edit mode data retrieval
        $(document).on('click', '.edit', function() {
            var identifier = $(this).data('id');
            var formdata = {
                ad_id: identifier,
                action: 'getoedit'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/adverts/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data) {
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();

                    $("#ad_id").val(data.ad_id);
                    $("#ad_name").val(data.ad_name);
                    $("#start").val(data.start);
                    $("#until").val(data.until);

                    var selectElement = document.getElementById('type');

                    var selectedOption = selectElement.querySelector('option[value="' + data.type + '"]');

                    if (selectedOption) {
                        selectedOption.selected = true;
                        selectElement.prepend(selectedOption);
                    }

                    $("#editModal").modal('show');
                },
                error: function() {
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $('#adUpdate').submit(function(e) {
            e.preventDefault();

            var formdata = new FormData(this);

            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing...");
            $('#adUpdate').attr('disabled', true);
            $.ajax({
                url: '/com/files/adverts/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#adUpdate').attr('disabled', false);

                    if (data.status == 200) {
                        showSuccessToast(data.message);
                        $("#editModal").modal('hide');
                        fetch_data();
                    } else {
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#adUpdate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // edit ad file retrieval
        $(document).on('click', '#file', function() {
            var identifier = $(this).data('id');
            var formdata = {
                ad_id: $("#ad_id").val(),
                action: 'getoedit'
            };
            $("#file").prop("disabled", true);
            $('#spinner3').html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/adverts/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data) {
                    $("#editModal").modal('hide');
                    $("#file").prop("disabled", false);
                    $('#spinner3').hide();

                    $("#f_ad_id").val(data.ad_id);
                    $("#ad_file").attr('src', window.location.protocol + "//" + window.location.hostname + data.ad_file);
                    $("#editFileModal").modal('show');
                },
                error: function() {
                    $('#spinner3').hide();
                    $("#file").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $('#adFileUpdate').submit(function(e) {
            e.preventDefault();

            var formdata = new FormData(this);

            $('#spinner4').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator4').html("...");
            $('#adFileUpdate').attr('disabled', true);
            $.ajax({
                url: '/com/files/adverts/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                processData: false,
                contentType: false,
                success: function(data) {
                    $('#spinner4').fadeOut('fast');
                    $('#indicator4').html("Save changes");
                    $('#adFileUpdate').attr('disabled', false);

                    if (data.status == 200) {
                        showSuccessToast(data.message);
                        $("#editFileModal").modal('hide');
                        fetch_data();
                    } else {
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner4').fadeOut('fast');
                    $('#indicator4').html("Save changes");
                    $('#adFileUpdate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // manage events
        $(document).on('click', '.manage', function() {
            var identifier = $(this).data('id');
            var formdata = {
                ad_id: identifier,
                action: 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/adverts/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data) {
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if (data.status == 200) {
                                showSuccessToast(data.message);
                                fetch_data();
                            } else {
                                showInfoToast(data.message);
                            }
                        },
                        error: function() {
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                } else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
</script>