<?php include'from.php'; ?>
<?php  include'top.php'; ?>
<?php 
    $event = (int)($_GET['ev']); 
    $ticket = (int)($_GET['tc']); 
?>

<div class="modal" id="termsModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="text-navy">Terms and conditions apply</h4>
            </div>
            <div class="modal-body">
                <p>Before proceeding with your purchase, we kindly ask you to take a moment to review our terms and conditions. These terms outline important information regarding your rights, responsibilities, and the terms of service that govern your interaction with our website.</p>
                <p>Please <a href="/terms" target="_blank" class="imlink"><?php echo 'https://'.str_replace('www.', '', $_SERVER['SERVER_NAME']).'/terms'; ?></a> here to access our terms and conditions.</p>
                
                <div class="wrapper-button">
                    <div class="col-11">
                        <p> I have ready and agree to the Terms and Conditions</p>
                    </div>
                    <div class="col-1">
                        <input type="checkbox" id="agree">
                    </div>
                </div><br>
                <p id="error" class="text-danger text-bold"></p>
            </div>
            <div class="modal-footer"> 
                <button type="button" class="btn btn-light" onclick="verifyAgreements();">Continue</button>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="statusModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="text-navy">Payment ongoing</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <p>Please wait while payment is being processed</p>
                <p>You will receive a confirmation SMS and Email When payment is complete!</p>
                
                <div class="col-12">
                    <label class="form-control sp"><span id="spinner2"></span>&nbsp;<span id="indicator2"></span></label>
                </div>
                <div class="form-group row notifier" hidden>
                    <div class="col-12">
                        <div class="col-12">
                            <label class="form-control info"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="displayspace" class="box p-50">
    <div class="main-content-wrapper">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-lg-12">
                    <div class="post-content-area mb-20">
                        <div class="world-catagory-area">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="world-tab-1" role="tabpanel" aria-labelledby="tab1">
                                    <div class="row">
                                        <div class="col-12 col-md-8">
                                            <?php
                                                $currentEvent = $db->query("SELECT ev.*, ven.long_name AS venue FROM tbl_events ev INNER JOIN tbl_venues ven ON ev.venue_id = ven.venue_id WHERE evt_id = '".$event."'");
                                                $keys = [];
                                                while($thisEvent = $currentEvent->fetch()){ 
                                                    $keys = explode(',', trim($thisEvent['pay_modes'], '[]'));
                                            ?>   
                                            <div class="single-blog-post">
                                                <div class="post-thumbnail radi">
                                                    <img src="https://m.<?php echo str_replace('www.', '', $_SERVER['SERVER_NAME']).$thisEvent['temp_bunner']; ?>" alt="">
                                                </div>
                                                <div class="post-content">
                                                    <a href="#" class="headline">
                                                        <h5 class="ellipsis"><?php  echo $thisEvent['evtname'] ?></h5>
                                                        <p><?php echo $thisEvent['event_desc'] ?></p>
                                                        <p><?php echo date("l, M d, Y", strtotime($thisEvent['start_date'])) ?></p>
                                                    </a>
                                                    <div class="spin4" id="spin<?php  echo $thisEvent['evt_id']; ?>"></div>
                                                    <div class="post-meta row">
                                                        <div class="col-4 col-lg-4 col-md-4">
                                                            <p>Start</p>
                                                            <p><b><?php echo date("H:i", strtotime($thisEvent['start_date'])) ?></b></p>
                                                        </div>
                                                        <div class="col-4 col-lg-4 col-md-4">
                                                            <p>Door Open</p>
                                                            <p><b><?php echo $thisEvent['op_door'] ?></b></p>
                                                        </div>
                                                        <div class="col-4 col-lg-4 col-md-4">
                                                            <p>Status</p>
                                                            <p><b><?php echo $thisEvent['disp'] == 1? 'Active':'Inactive' ?></b></p>
                                                        </div>
                                                        
                                                        <div class="col-4 col-lg-4 col-md-4 pt-30">
                                                            <p>Venue</p>
                                                            <p><b><?php echo $thisEvent['venue'] ?></b></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <?php 
                                                $enabledModes = $keys;
                                                $placeholders = implode(",", $enabledModes);
                                                $getEventPaymentModes = $db->query("SELECT 
                                                                                        	ok.key_id,
                                                                                            m.mode_name,
                                                                                            m.icon
                                                                                        FROM tbl_owner_keys ok 
                                                                                            INNER JOIN tbl_pay_modes m ON ok.mode_id = m.mode_id 
                                                                                        WHERE ok.key_id IN ($placeholders) AND ok.status = 1 AND m.status = 1
                                                                                    ");
                                                if($getEventPaymentModes->rowCount()>0){
                                            ?>
                                            <div class="">
                                                <label class="single-blog-post">
                                                    <div class="post-content">
                                                        <h6  class="form-text text-muted">How are you going to pay?</h6>    
                                                        <div style="payfooter">
                                                            <?php 
                                                                while($paymode = $getEventPaymentModes->fetch()){
                                                                    $icon = 'https://m.'.str_replace('www.', '', $_SERVER['SERVER_NAME']).$paymode['icon'];
                                                            ?>
                                                            <img src="<?php echo $icon; ?>" class="mode" value="<?php echo $paymode['key_id'] ?>" onclick="toggleSelectionMode(this)">
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include'end.php'; ?>

<div class="modal" id="SupportModal">
    <form action="" method="POST" id="SupportForm" autocomplete="off">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Event Support</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="event" class="form-control" value="<?php echo $event; ?>">
                    <input type="hidden" id="pmode" name="pmode" class="form-control">
                    <div class="form-group row">
                        <div class="col-12">
                            <label class="col-form-label col-12">Amount</label>
                            <div class="col-12">
                                <input type="text" class="form-control" name="amount" min="100" oninput="cleanPhoneNumber(this)" required>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="col-form-label col-12">Name</code></label>
                            <div class="col-12">
                                <input type="text" class="form-control" name="usNames" placeholder="John Doe">
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="col-form-label col-12">Phone Number - <code>Paying number</code></label>
                            <div class="col-12">
                                <input type="text" class="form-control" name="payer_phone" id="payer_phone" minLength="10" maxLenght="12" oninput="cleanPhoneNumber(this)" placeholder="07XXXXXXXX" required>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="col-form-label col-12">Email - <code>Optional</code></label>
                            <div class="col-12">
                                <input type="email" class="form-control" name="email" placeholder="example@domain.com">
                            </div>
                        </div>
                    </div>
                    <div class="form-group row notifier" hidden>
                        <div class="col-12">
                            <div class="col-12">
                                <label class="form-control info"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer"> 
                    <button type="button" class="btn btn-light off" data-dismiss="modal">Close</button>
                    <button type="submit" id="purchase" class="btn btn-success"><span id="spinner"></span>&nbsp;<span id="indicator">Pay</span></button>
                </div>
            </div>
        </div>
    </form>
</div>
    
<script>
    function validatePhoneNumber(phone) {
        var pattern = /^07[2389]\d{7}$/;
        if (pattern.test(phone.trim())) {
            return true;
        }else{
            return false;
        }
    }
    
    function cleanPhoneNumber(input) {
        var phoneNumber = input.value;
        var cleanedPhoneNumber = phoneNumber.replace(/[^+0-9]/g, "");
        input.value = cleanedPhoneNumber;
    }
    
    function toggleSelectionMode(element) {
        var modes = document.getElementsByClassName('mode');
        for (var i = 0; i < modes.length; i++) {
            modes[i].classList.remove('mselected');
        }
        
        element.classList.add('mselected');
        document.getElementById("pmode").setAttribute('value', element.getAttribute('value'));
        $("#SupportModal").modal('show');
        return;
    }
</script>

<script>
    function pop_up_success(feedback) {
        const infoElements = document.getElementsByClassName("info");
        for (let i = 0; i < infoElements.length; i++) {
            const label = infoElements[i];
            label.classList.remove('warning');
            label.classList.add('success');
            label.innerHTML = feedback;
        }
        
        const notifierElements = document.getElementsByClassName("notifier");
        for (let i = 0; i < notifierElements.length; i++) {
            const notifier = notifierElements[i];
            notifier.removeAttribute('hidden');
        }
    }
    
    function pop_up_info(feedback) {
        const infoElements = document.getElementsByClassName("info");
        for (let i = 0; i < infoElements.length; i++) {
            const label = infoElements[i];
            label.classList.remove('success');
            label.classList.add('warning');
            label.innerHTML = feedback;
        }
        
        const notifierElements = document.getElementsByClassName("notifier");
        for (let i = 0; i < notifierElements.length; i++) {
            const notifier = notifierElements[i];
            notifier.removeAttribute('hidden');
        }
    }  
	
	$(document).ready(function(){
        $("#SupportForm").submit(function(e){
            e.preventDefault();
            if(!validatePhoneNumber($("#payer_phone").val())){
                pop_up_info("Please enter a valid phone number starting with 078 or 079");
                return;
            }
            var formdata = new FormData(this);
            
            $("#spinner, #spinner2").show();
            $("#spinner, #spinner2").show();
            $(".sp").show();
            
            $("#spinner, #spinner2").html('<img src="./img/ajax_loader.gif" alt="" width="15" />');
            $("#indicator, #indicator2").html('processing...');

            $("#statusModal").modal('show');
            $("#SupportModal").modal('hide');
            
            $(".notifier").attr('hidden', true);
            $("#SupportForm :button").prop("disabled", true);

            $.ajax({
                url: "./src/donation.php",       
                type: "POST",
                data: formdata,
                contentType: false,
                processData: false,
                dataType: "JSON", 
                success: function(response){
                    $("#spinner, #spinner2, .sp").hide();
                    $("#indicator2").html('');
                    $("#SupportForm :button").prop("disabled", false);

                    if (response['status'] == 200) {
                        $("#indicator").html('Pay');
                        pop_up_success(response['message']);
                    } else{
                        pop_up_info(response['message']);
                        $("#indicator").html('Retry');
                        setTimeout(function(){
                            $("#statusModal").modal('hide');
                            $("#SupportModal").modal('show');
                        }, 2000);
                    }
                },error: function(){
                    $("#spinner, #spinner2, .sp").hide();
                    $("#indicator").html('Retry');
                    $("#indicator2").html('');
                    $("#SupportForm :button").prop("disabled", false);
                    pop_up_info("Something went wrong!");
                    setTimeout(function(){
                        $("#statusModal").modal('hide');
                        $("#SupportModal").modal('show');
                    }, 2000);
                }
            });
        });
	})
</script>