<?php
    ini_set('log_errors', 0);
    include('./com/phpqrcode/qrlib.php');
    require('./com/fpdf/fpdf.php');
    require_once '../join/configure.php';
    require_once './utils.php';
    require_once './controllers.php';
    require_once './processor.php';
    require_once './communication.php';
    
    $event =  $_POST['event'];
    $plan = $_POST['plan'];
    $pmode = $_POST['pmode'];
    $ticket_count = $_POST['ticket_count'];
    $payer = $_POST['payer_phone'];
    $email = $_POST['email'] !==""?$_POST['email']:'tickets@ibitaramo.com';
    $isSupport = (int)$_POST['sup'];
    
    $isValid = validateRequest($event, $plan, $pmode, $db);
    
    if($isValid){
        $holders = array();
        
        foreach($_POST['holders'] as $holder){
            array_push($holders, $holder);
        }
        $seats = getPlanSeats($db, $plan);
        $seats = $seats * $ticket_count;
        $price = getPlanAmount($plan, $db);
        $amount = $ticket_count * $price;

        $keyd = getPaymentKey($pmode, $db);
        $key = $keyd['ipay_key'];
        $mode = $keyd['mode_id'];
        
        if($key != NULL){
            if($mode == 2 || $mode == 4){
                $lastId = insertPayTrial($db, $event, $amount, $holders[0], $email, $payer, $pmode, 3);
                $paymentData = doPayment($amount, $key, $payer);
    
                $status = $paymentData['status'];
        
                if($status===200){
                    // $amount = $paymentData['data']['amount']; //use original amount
                    $uniqueId = $paymentData['data']['transID'];
    
                    manageTicketsAndNotify($db, $currency, $isSupport, $uniqueId, $lastId, $plan, $seats, $event, $amount, $holders, $payer, $email, $pmode);
                    sendFeedback(200, "Payment done successfully, check your message box. Thank you!");
                }
                else{
                    sendFeedback(400, "Failed to process payment, check your balance and retry!");
                }
            } 
            if($mode == 1){
                $lastId = insertPayTrial($db, $event, $amount, $holders[0], $email, $payer, $pmode, 3);
                $paymentData = doPayment2($amount, $key, $payer);
                $financial_id = null;
                $success = false;

                if($paymentData['status']===200){
                    if(isset($paymentData['data']) && $paymentData['data']['status'] != 'FAILED'){
                        if(isset($paymentData['data']['financialTransactionId'])){
                            $financial_id = $paymentData['data']['financialTransactionId'];
                            $req_ref = $paymentData['data']['externalId'];
                            $payer = '';
                            $success = true;
                            //check for payer 
                            if(isset($paymentData['data']['payer'])){
                                $payer = $paymentData['data']['payer']['partyId'];
                            }

                        }
                    }
                }

                if($success){
                    // update_pay_trial_meta($access, $ptck_id,$req_ref, $price_id, $tcount, $holders, $financial_id){
                    $holders = json_encode($holders);
                    update_pay_trial_meta($db, $lastId, $req_ref, $plan, $ticket_count, $holders, $financial_id);
                    sendFeedback(200, "Payment Request initiated, please follow the instructions on your phone to complete the transaction, or dial *182*7*1# to complete the transaction. Once done wait for 5 seconds for your ticket via SMS to ".$payer." Thank you!");
                }else{
                    sendFeedback(400, "Failed to process payment, check your balance and retry!");
                }

            } else{
                $purchaseResponse = json_decode(requestPurchaseCode($amount, $key, $email), true);
                
                $status = $purchaseResponse['status'];

                if($status===200){
                    $PCODE = $purchaseResponse['PCODE'];
                    $link = $purchaseResponse['link'];
    
                    saveAndRedirect($db, $PCODE, $event, $plan, $ticket_count, $email, $payer, $holders[0], $link);
                }
                else{
                    sendFeedback(400, "Failed to process payment, check your balance and retry!");
                }
            }
            
        }else{
            sendFeedback(400, "This event is not open for purchase!");
        }
    }else{
        sendFeedback(400, "Unauthorized modifications!");
    }
?>
