<?php include'from.php'; ?>
<?php  include'top.php'; ?>
<?php 
    $event = (int)($_GET['ev']); 
    $ticket = (int)($_GET['tc']);
?>

<div class="modal" id="termsModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="text-navy">Terms and conditions apply</h4>
            </div>
            <div class="modal-body">
                <p>Before proceeding with your purchase, we kindly ask you to take a moment to review our terms and conditions. These terms outline important information regarding your rights, responsibilities, and the terms of service that govern your interaction with our website.</p>
                <p>Please <a href="/terms" target="_blank" class="imlink"><?php echo 'https://'.str_replace('www.', '', $_SERVER['SERVER_NAME']).'/terms'; ?></a> here to access our terms and conditions.</p>
                
                <div class="wrapper-button">
                    <div class="col-11">
                        <p> I have ready and agree to the Terms and Conditions</p>
                    </div>
                    <div class="col-1">
                        <input type="checkbox" id="agree">
                    </div>
                </div><br>
                <p id="error" class="text-danger text-bold"></p>
            </div>
            <div class="modal-footer"> 
                <button type="button" class="btn btn-light" onclick="verifyAgreements();">Continue</button>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="statusModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="text-navy">Payment ongoing</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <p>Please wait while payment is being processed</p>
                <p>You will receive a confirmation SMS and Email When payment is complete!</p>
                
                <div class="col-12">
                    <label class="form-control sp"><span id="spinner2"></span>&nbsp;<span id="indicator2"></span></label>
                </div>
                <div class="form-group row notifier" hidden>
                    <div class="col-12">
                        <div class="col-12">
                            <label class="form-control info"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="displayspace" class="box p-50">
    <div class="main-content-wrapper">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-lg-12">
                    <div class="post-content-area mb-20">
                        <div class="world-catagory-area">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="world-tab-1" role="tabpanel" aria-labelledby="tab1">
                                    <div class="row">
                                        <div class="col-12 col-md-7">
                                            <?php
                                                $currentEvent = $db->query("SELECT ev.*, ven.long_name AS venue FROM tbl_events ev INNER JOIN tbl_venues ven ON ev.venue_id = ven.venue_id WHERE evt_id = '".$event."'");
                                                $keys = [];
                                                while($thisEvent = $currentEvent->fetch()){ 
                                                    $keys = explode(',', trim($thisEvent['pay_modes'], '[]'));
                                            ?>   
                                            <div class="single-blog-post">
                                                <div class="post-thumbnail radi">
                                                    <img src="https://m.<?php echo str_replace('www.', '', $_SERVER['SERVER_NAME']).$thisEvent['temp_bunner']; ?>" alt="">
                                                </div>
                                                <!--<div class="post-content">-->
                                                <!--    <a href="#" class="headline">-->
                                                <!--        <h5 class="ellipsis"><?php  echo $thisEvent['evtname'] ?></h5>-->
                                                <!--        <p><?php echo $thisEvent['event_desc'] ?></p>-->
                                                <!--        <p><?php echo date("l, M d, Y", strtotime($thisEvent['start_date'])) ?></p>-->
                                                <!--    </a>-->
                                                <!--    <div class="spin4" id="spin<?php  echo $thisEvent['evt_id']; ?>"></div>-->
                                                <!--    <div class="post-meta row">-->
                                                <!--        <div class="col-4 col-lg-4 col-md-4">-->
                                                <!--            <p>Start</p>-->
                                                <!--            <p><b><?php echo date("H:i", strtotime($thisEvent['start_date'])) ?></b></p>-->
                                                <!--        </div>-->
                                                <!--        <div class="col-4 col-lg-4 col-md-4">-->
                                                <!--            <p>Door Open</p>-->
                                                <!--            <p><b><?php echo $thisEvent['op_door'] ?></b></p>-->
                                                <!--        </div>-->
                                                <!--        <div class="col-4 col-lg-4 col-md-4">-->
                                                <!--            <p>Status</p>-->
                                                <!--            <p><b><?php echo $thisEvent['disp'] == 1? 'Active':'Inactive' ?></b></p>-->
                                                <!--        </div>-->
                                                        
                                                <!--        <div class="col-4 col-lg-4 col-md-4 pt-30">-->
                                                <!--            <p>Venue</p>-->
                                                <!--            <p><b><?php echo $thisEvent['venue'] ?></b></p>-->
                                                <!--        </div>-->
                                                <!--    </div>-->
                                                <!--</div>-->
                                            </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-12 col-md-5">
                                            <?php 
                                                $icon = 'https://m.'.$_SERVER['SERVER_NAME']."/images/tickets/icons/ticket.svg";
                                                $getEventTickets = $db->query('SELECT * FROM tbl_ticket_price WHERE event_id="'.$event.'" AND price_id="'.$ticket.'" AND post = 1');
                                                $available = 0;
                                                while($eventTicket = $getEventTickets->fetch()){ 
                                                    $priceId = $eventTicket['price_id'];
                                                    $ticketValue = $eventTicket['price'];
                                                    
                                                    $checkStore = $db->query("SELECT * FROM tbl_con_tickets WHERE evt_id='".$event."' AND price_id='".$priceId."'");
                                                    $store = $checkStore->rowCount();

                                                    $getSoldEventTickets = $db->query("SELECT COUNT(con_tck_id) AS sold FROM  tbl_con_tickets  WHERE evt_id='".$event."' AND price_id='".$priceId."' AND tck_status = 4");
                                                    $soldTickets = $getSoldEventTickets->fetch();
                                                    $available = $eventTicket['seats']*$eventTicket['tick_num'] - $soldTickets['sold'];
                                                    
                                                    if($store == 0){
                                                        $available = 0;
                                                    }
                                                    if($priceId==$ticket){
                                                        $maximum = $available/$eventTicket['seats'];
                                                    }
                                            ?>
                                            <a href="<?php echo $available>0?'purchase?ev='.$event.'&tc='.$priceId:'#' ?>">
                                                <div class="single-blog-post post-style-2 d-flex align-items-center widget-post list <?php echo $priceId==$ticket && $available>0?'selected':'' ?>">
                                                    <div class="post-thumbnail">
                                                        <img src="<?php echo $available>0?$icon:'evt/sold-out.png' ?>" alt="">
                                                    </div>
                                                    <input type="hidden" id="ticketValue" value="<?php echo $ticketValue; ?>">
                                                    <div class="post-content ">
                                                        <div class="headline">
                                                            <h5 class="text-navy"><?php echo $eventTicket['price_plan']." | ".number_format($eventTicket['price']); ?></h5>
                                                            <p><?php echo $eventTicket['planDesc']; ?></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                            
                                            <input type="hidden" id="seat_count" value="<?php echo $eventTicket['seats']; ?>" class="form-control">
                                            <input type="hidden" id="maximum" value="<?php echo $maximum; ?>">
                                            
                                            <?php if($available > 0){ ?>
                                            <div class="single-blog-post post-style-2 d-flex align-items-center widget-post">
                                                <div class="post-thumbnail">
                                                    <img src="img/money.svg" alt="">
                                                </div>
                                                <div class="post-content ">
                                                    <div class="headline">
                                                        <h1 class="text-navy" id="amIndic">0</h1>
                                                        <p><?php echo $currency; ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="single-blog-post post-style-2 d-flex align-items-center widget-post">
                                                <div class="post-thumbnail">
                                                    <img src="img/copy.svg" alt="">
                                                </div>
                                                <div class="post-content ">
                                                    <div class="headline">
                                                        <div class="wrapper-num">
                                                            <span class="minus" onclick="decrementTickets()">-</span>
                                                            <input type="text" id="tcount" value="0" class="form-control" readonly>
                                                            <span class="plus" onclick="incrementTickets()">+</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } ?>
                                            <?php } ?>
                                            <?php 
                                                $enabledModes = $keys;
                                                $placeholders = implode(",", $enabledModes);
                                                $getEventPaymentModes = $db->query("
                                                                                    SELECT 
                                                                                        	ok.key_id,
                                                                                            m.mode_name,
                                                                                            m.icon
                                                                                        FROM tbl_owner_keys ok 
                                                                                            INNER JOIN tbl_pay_modes m ON ok.mode_id = m.mode_id 
                                                                                        WHERE ok.key_id IN ($placeholders) AND ok.status = 1 AND m.status = 1
                                                                                    ");
                                                if($getEventPaymentModes->rowCount()>0){
                                            ?>
                                            <div class="">
                                                <label class="single-blog-post">
                                                    <div class="post-content">
                                                        <h6  class="form-text text-muted">How are you going to pay?</h6>    
                                                        <div style="payfooter">
                                                            <?php 
                                                                while($paymode = $getEventPaymentModes->fetch()){
                                                                    $icon = 'https://m.'.str_replace('www.', '', $_SERVER['SERVER_NAME']).$paymode['icon'];
                                                            ?>
                                                            <img src="<?php echo $icon; ?>" class="mode" value="<?php echo $paymode['key_id'] ?>" onclick="toggleSelectionMode(this)">
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include'end.php'; ?>

<div class="modal" id="TicketModal">
    <form action="" method="POST" id="TicketForm" autocomplete="off">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Ticket Purchase</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="event" class="form-control" value="<?php echo $event; ?>">
                    <input type="hidden" name="plan" class="form-control" value="<?php echo $ticket; ?>">
                    <input type="hidden" id="pmode" name="pmode" class="form-control">
                    <input type="hidden" id="ticket_count" name="ticket_count" class="form-control" value="0">
                    <input type="hidden" name="sup" class="form-control" value="0">

                    <div class="form-group row" id="name-container">
                        <div class="col-12">
                            <label class="col-form-label col-12">Phone Number - <code>Paying number</code></label>
                            <div class="col-12">
                                <input type="text" class="form-control" name="payer_phone" id="payer_phone" minLength="10" maxLenght="12" oninput="cleanPhoneNumber(this)" placeholder="07XXXXXXXX" required>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="col-form-label col-12">Email - <code>Optional</code></label>
                            <div class="col-12">
                                <input type="email" class="form-control" name="email" placeholder="example@domain.com">
                            </div>
                        </div>
                    </div>
                    <div class="form-group row notifier" hidden>
                        <div class="col-12">
                            <div class="col-12">
                                <label class="form-control info"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer"> 
                    <button type="button" class="btn btn-light off" data-dismiss="modal">Close</button>
                    <button type="submit" id="purchase" class="btn btn-success"><span id="spinner"></span>&nbsp;<span id="indicator">Pay</span></button>
                </div>
            </div>
        </div>
    </form>
</div>
    
<script>
    function verifyAgreements(){
        var agreement = document.getElementById("agree");
        if(agreement.checked){
            localStorage.setItem('ibitaramo_terms', 'agree');
            $("#termsModal").modal("hide");
        }else{
            document.getElementById("error").innerHTML = "You must agree to our terms and conditions first.";
        }
    }
    function validatePhoneNumber(phone) {
        var pattern = /^07[2389]\d{7}$/;
        if (pattern.test(phone.trim())) {
            return true;
        }else{
            // return false;
            return true;
        }
    }
    
    function cleanPhoneNumber(input) {
        var phoneNumber = input.value;
        var cleanedPhoneNumber = phoneNumber.replace(/[^+0-9]/g, "");
        input.value = cleanedPhoneNumber;
    }
    
    function number_format(number, decimals, dec_point, thousands_sep) {
        // Default values for decimals, dec_point, and thousands_sep
        decimals = decimals || 0;
        dec_point = dec_point || '.';
        thousands_sep = thousands_sep || ',';
    
        // Convert number to a string
        number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
    
        var n = !isFinite(+number) ? 0 : +number,
            prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
            sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
            dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
            s = '';
    
        // Fix for IE parseFloat(0.55).toFixed(0) = 0;
        s = (prec ? parseFloat(n).toFixed(prec) : '' + Math.round(n)).split('.');
    
        var re = /(-?\d+)(\d{3})/;
        while (re.test(s[0])) {
            s[0] = s[0].replace(re, '$1' + sep + '$2');
        }
    
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
    
        return s.join(dec);
    }

    function toggleSelectionMode(element) {
        var modes = document.getElementsByClassName('mode');
        for (var i = 0; i < modes.length; i++) {
            modes[i].classList.remove('mselected');
        }
        
        element.classList.add('mselected');
        document.getElementById("pmode").setAttribute('value', element.getAttribute('value'));
        if(document.querySelector(".selected") !== null && document.getElementById("tcount").getAttribute('value') > 0){
            $("#TicketModal").modal('show');
        }
        return;
    }
</script>

<script>
    function show_terms(){
        if(localStorage.getItem('ibitaramo_terms') != 'agree'){
            $("#termsModal").modal({backdrop: 'static', keyboard: false}, 'show');
        }
    }
	function incrementTickets(){
	    var tickets = parseInt(document.getElementById("tcount").getAttribute('value'));
        var maximum = parseInt(document.getElementById("maximum").getAttribute('value'));
        var seats = parseInt(document.getElementById("seat_count").getAttribute('value'));
	    
	    var counter = tickets;
	    var incr = seats * counter + 1;
	    
        var amount = document.getElementById("ticketValue").getAttribute('value');
        
	    if(counter + 1 <= maximum){
	        counter += 1;
    	    document.getElementById("ticket_count").setAttribute('value', counter);
            document.getElementById("tcount").setAttribute('value', counter);
            document.getElementById("amIndic").innerHTML = number_format(counter * amount, 0, '.', ',');
	        for(var c = 1; c <= seats; c++){
                // Create container element
                const container = document.getElementById('name-container');
                const entryContainer = document.createElement('div');
                entryContainer.className = 'col-12 entry';
                
                // Create the label element
                const label0 = document.createElement('label');
                const label = document.createElement('label');
                label.className = 'col-form-label col-12';
                label.textContent = 'Name ' + incr;
            
                // Create the input element
                const input = document.createElement('input');
                input.type = 'text';
                input.className = 'form-control';
                input.name = 'holders[]';
                input.setAttribute('required', true);
                const divContainer = document.createElement('div');
                divContainer.className = 'col-12';
                divContainer.appendChild(input);
            
                // Append elements
                entryContainer.appendChild(label);
                entryContainer.appendChild(divContainer);
                container.appendChild(entryContainer);
                incr++;
	        }
	    }
        return;
	} 
	
	function decrementTickets(){
	    if(parseInt(document.getElementById("tcount").getAttribute('value')) > 1){
	        var seats = parseInt(document.getElementById("seat_count").getAttribute('value'));
	        var amount = document.getElementById("ticketValue").getAttribute('value');
	        var counter = parseInt(document.getElementById("tcount").getAttribute('value'));
	        counter -= 1;
	        
	        for(var c = 1; c <= seats; c++){
    	        document.getElementById("ticket_count").setAttribute('value', counter);
    	        document.getElementById("tcount").setAttribute('value', counter);
                var parentDiv = document.getElementById("name-container");
                var childDivs = parentDiv.getElementsByClassName("entry");
                var lastDiv = childDivs[childDivs.length - 1];
                parentDiv.removeChild(lastDiv);
	        }
            document.getElementById("amIndic").innerHTML = number_format(counter * amount, 0, '.', ',');
	    }
	    return;
	}
	
    function pop_up_success(feedback) {
        const infoElements = document.getElementsByClassName("info");
        for (let i = 0; i < infoElements.length; i++) {
            const label = infoElements[i];
            label.classList.remove('warning');
            label.classList.add('success');
            label.innerHTML = feedback;
        }
        
        const notifierElements = document.getElementsByClassName("notifier");
        for (let i = 0; i < notifierElements.length; i++) {
            const notifier = notifierElements[i];
            notifier.removeAttribute('hidden');
        }
    }
    
    function pop_up_info(feedback) {
        const infoElements = document.getElementsByClassName("info");
        for (let i = 0; i < infoElements.length; i++) {
            const label = infoElements[i];
            label.classList.remove('success');
            label.classList.add('warning');
            label.innerHTML = feedback;
        }
        
        const notifierElements = document.getElementsByClassName("notifier");
        for (let i = 0; i < notifierElements.length; i++) {
            const notifier = notifierElements[i];
            notifier.removeAttribute('hidden');
        }
    }  
	
	$(document).ready(function(){
	    show_terms();
	    incrementTickets();
        $("#TicketForm").submit(function(e){
            e.preventDefault();
            if(!validatePhoneNumber($("#payer_phone").val())){
                pop_up_info("Please enter a valid phone number starting with 078 or 079");
                return;
            }
            var formdata = new FormData(this);
            
            $("#spinner, #spinner2").show();
            $("#spinner, #spinner2").show();
            $(".sp").show();
            
            $("#spinner, #spinner2").html('<img src="./img/ajax_loader.gif" alt="" width="15" />');
            $("#indicator, #indicator2").html('processing...');

            $("#statusModal").modal('show');
            $("#TicketModal").modal('hide');
            
            $(".notifier").attr('hidden', true);
            $("#TicketForm :button").prop("disabled", true);

            $.ajax({
                url: "./src/index.php",       
                type: "POST",
                data: formdata,
                contentType: false,
                processData: false,
                dataType: "JSON", 
                success: function(response){
                    $("#spinner, #spinner2, .sp").hide();
                    $("#indicator2").html('');
                    $("#TicketForm :button").prop("disabled", false);

                    if (response['status'] == 200) {
                        $("#indicator").html('Pay');
                        pop_up_success(response['message']);
                    } else if(response['status'] == 307){
                        window.open(response['message']);
                    } else{
                        pop_up_info(response['message']);
                        $("#indicator").html('Retry');
                        setTimeout(function(){
                            $("#statusModal").modal('hide');
                            $("#TicketModal").modal('show');
                        }, 2000);
                    }
                },error: function(){
                    $("#spinner, #spinner2, .sp").hide();
                    $("#indicator").html('Retry');
                    $("#indicator2").html('');
                    $("#TicketForm :button").prop("disabled", false);
                    pop_up_info("Something went wrong!");
                    setTimeout(function(){
                        $("#statusModal").modal('hide');
                        $("#TicketModal").modal('show');
                    }, 2000);
                }
            });
        });
	})
</script>