<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function fetch_data(event, agent){
        var formData = {
            event: event,
            agent: agent
        }
        $('#list').removeAttr('hidden');
        $('#generator').attr('disabled', true);
        $.ajax({
            url: "/com/files_v2/reports/ftc24442024.php",
            type: "POST",
            data: formData,
            mimeTypes: "multipart/form-data",
            success: function(data){
                $(".loader-demo-box").remove();
                $('#list').html(data);
                $('#listing').DataTable();
                $('#generator').removeAttr('disabled');
            },error: function(){
                $(".loader-demo-box").remove();
                $('#list').attr('hidden', true);
                $('#generator').removeAttr('disabled');
                showWarningToast("Something went wrong!");
                
            }
        }); 
    }
    
    $(document).ready(function(){
        $('#generator').on('click', function(event) {
            fetch_data($("#event").val(), $("#agents").val());
        });
        
        $("#event").change(function () {
            var formdata = {
                    event: $(this).val(),
                    action: 'get_agents'
                };
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='30'>").fadeIn('fast');
            $('#generator').attr('hidden', true);
            
            $.ajax({
                type: "POST",
                url: "/com/files/events/controller.php",
                data: formdata,
                dataType: "JSON",
                success: function (data) {
                    $('#spinner').fadeOut('fast');
                    $("#agents").empty();
                    if(data.length>0){
                        $("#agents").append("<option>Choose one...</option>");
                        $.each(data, function (index, value) {
                            $("#agents").append("<option value='" + value.account_id + "'>" + value.first_name +" " + value.family_name +"</option>");
                        });
                        $('#generator').removeAttr('hidden', true);
                    }
                },
                error:function(error){
                    $('#spinner').fadeOut('fast');
                    showWarningToast("Something went wrong!");
                }
            });
        });
    });
</script>