<?php /** Author: @hicode **/ ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function fetch_data(event, plan){
        var formData = {
            event: event,
            plan: plan
        }
        $('#list').removeAttr('hidden');
        $('#generator').attr('disabled', true);
        $.ajax({
            url: "/com/files_v2/reports/ftc23442024.php",
            type: "POST",
            data: formData,
            mimeTypes: "multipart/form-data",
            success: function(data){
                $(".loader-demo-box").remove();
                $('#list').html(data);
                $('#listing').DataTable();
                $('#generator').attr('disabled', false);
            },error: function(){
                $(".loader-demo-box").remove();
                $('#list').attr('hidden', true);
                $('#generator').attr('disabled', false);
                showWarningToast("Something went wrong!");
                
            }
        }); 
    }
    
    $(document).ready(function(){
        $('#generator').on('click', function(event) {
            fetch_data($("#event").val(), $("#plan").val());
        });
        
        $("#event").change(function () {
            var formdata = {
                    event: $(this).val(),
                    action: 'get_plans'
                };
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='30'>").fadeIn('fast');
            $('#generator').attr('hidden', true);
            
            $.ajax({
                type: "POST",
                url: "/com/files/events/controller.php",
                data: formdata,
                dataType: "JSON",
                success: function (data) {
                    $('#spinner').fadeOut('fast');
                    $("#plan").empty();
                    var post = "";
                    if(data.length>0){
                        $.each(data, function (index, value) {
                            post = "Online";
                            if(value.post == 0){
                                post = "HardC";
                            }
                            $("#plan").append("<option value='" + value.price_id + "'>" + value.price_plan +" - " + post +"</option>");
                        });
                        $('#generator').removeAttr('hidden', true);
                    }
                },
                error:function(error){
                    $('#spinner').fadeOut('fast');
                    pop_wrong("Something went wrong!");
                }
            });
        });
    });
</script>