<?php /** Author: @hicode **/ ?>
<?php
    ini_set('display_errors', 1);
    include '../../config/connect.php';
    include '../utils/functions.php';
    
    $connection=$conn;
    class Event{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function saveEventEntity($evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS){
            $stmt = $this->connect->prepare("INSERT INTO tbl_events(evtname, event_desc, catg_id, owner_id, venue_id, telMnge, telSupp, start_date, op_door, evtSMS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS]);
            return;
    	}
    
    	
    	public function updateEventEntity($evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS, $evt_id){
            $stmt = $this->connect->prepare("UPDATE tbl_events SET evtname = ?, event_desc = ?, catg_id = ?, owner_id = ?, venue_id = ?, telMnge = ?, telSupp = ?, start_date = ?, op_door = ?, evtSMS = ? WHERE evt_id = ?");
            $stmt->execute([$evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS, $evt_id]);
            return;
    	}
    	
    	public function updateEventEntityFile($evt_id, $temp_bunner){
            $stmt = $this->connect->prepare("UPDATE tbl_events SET temp_bunner = ? WHERE evt_id = ?");
            $stmt->execute([$temp_bunner, $evt_id]);
            return;
    	}
    	
    	public function updateEventEntityFile2($evt_id, $temp_bunner_2){
            $stmt = $this->connect->prepare("UPDATE tbl_events SET temp_bunner_2 = ? WHERE evt_id = ?");
            $stmt->execute([$temp_bunner_2, $evt_id]);
            return;
    	}
    	
    	public function updateEventEntityFile3($evt_id, $temp_bunner_pin){
            $stmt = $this->connect->prepare("UPDATE tbl_events SET temp_bunner_pin = ? WHERE evt_id = ?");
            $stmt->execute([$temp_bunner_pin, $evt_id]);
            return;
    	}
    	
    	public function updateEventEntitySPlan($evt_id, $sitting_plan){
            $stmt = $this->connect->prepare("UPDATE tbl_events SET sitting_plan = ? WHERE evt_id = ?");
            $stmt->execute([$sitting_plan, $evt_id]);
            return;
    	}
    	
        public function save_event(){
            $evtname = $_POST['evtname'];
            $event_desc = $_POST['event_desc'];
            $catg_id = $_POST['catg_id'];
            $owner_id = $_POST['owner_id'];
            $evtSMS = $_POST['evtSMS'];
            $venue_id = $_POST['venue_id'];
            $telMnge = $_POST['telMnge'];
            $telSupp = $_POST['telSupp'];
            $start_date = $_POST['start_date'];
            $op_door = $_POST['op_door'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evtname = ? AND DATE_FORMAT('%Y-%m-%d', start_date) = ?");
            $stmt->execute([$evtname, $start_date]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Event Already exists!");
            }
            else{ 
                $this->saveEventEntity($evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS);
                sendFeedback(200, "Event created successfully!");
            }
    	}
    	
        public function get_event(){
        	$evt_id = $_POST['evt_id'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evt_id = ?");
            $stmt->execute([$evt_id]);
            $data = $stmt->fetch();
            sendDataFeedback($data);
            return;
        }
                
        public function update_event(){
            $evt_id = $_POST['evt_id'];  
            $evtname = $_POST['evtname'];
            $event_desc = $_POST['event_desc'];
            $catg_id = $_POST['catg_id'];
            $owner_id = $_POST['owner_id'];
            $evtSMS = $_POST['evtSMS'];
            $venue_id = $_POST['venue_id'];
            $telMnge = $_POST['telMnge'];
            $telSupp = $_POST['telSupp'];
            $start_date = $_POST['start_date'];
            $op_door = $_POST['op_door'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evtname = ? AND DATE_FORMAT('%Y-%m-%d', start_date) = ? AND evt_id != ?");
            $stmt->execute([$evtname, $start_date, $evt_id]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Event Already exists!");
            }
            else{ 
                $this->updateEventEntity($evtname, $event_desc, $catg_id, $owner_id, $venue_id, $telMnge, $telSupp, $start_date, $op_door, $evtSMS, $evt_id);
                sendFeedback(200, "Event updated successfully!");
            }
        }
        
        public function upload_files(){
            $evt_id = $_POST['evt_id'];
            if($_FILES['temp_bunner']['tmp_name'] != ''){
                $temp_bunner = upload_event_image($_FILES['temp_bunner']);
                $this->updateEventEntityFile($evt_id, $temp_bunner);
            }
            
            if($_FILES['temp_bunner_2']['tmp_name'] != ''){
                $temp_bunner_2 = upload_event_image($_FILES['temp_bunner_2']);
                $this->updateEventEntityFile2($evt_id, $temp_bunner_2);
            }
            
            if($_FILES['temp_bunner_pin']['tmp_name'] != ''){
                $temp_bunner_pin = upload_event_image($_FILES['temp_bunner_pin']);
                $this->updateEventEntityFile3($evt_id, $temp_bunner_pin);
            }
            
            if($_FILES['sitting_plan']['tmp_name'] != ''){
                $sitting_plan = upload_event_image($_FILES['sitting_plan']);
                $this->updateEventEntitySPlan($evt_id, $sitting_plan);
            }
            
            sendFeedback(200, "Event updated successfully!");
        }
    
    	public function manage_Event(){
            $evt_id = $_POST['evt_id'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evt_id = ?");
            $stmt->execute([$evt_id]);
            $prevData=$stmt->fetch();
            if($prevData['disp']==1){
                $disp=2;
            }
            else{
                $disp=1;
            }
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_events SET disp = ? WHERE evt_id = ?");
            if($stmt2->execute([$disp, $evt_id])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
        
        public function get_pay_modes($event){
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evt_id = ?");
            $stmt->execute([$event]);
            
            $modes = array();
            
            while($row = $stmt->fetch()) {
                $keys = explode(',', trim($row['pay_modes'], '[]'));

                $enabledModes = $keys;
                $placeholders = implode(",", $enabledModes);
                 if(empty($placeholders)){
                    $placeholders = 0;
                }
                $getEventPaymentModes = $this->connect->prepare("
                                                    SELECT
                                                            ok.key_id,
                                                            m.mode_name
                                                        FROM tbl_owner_keys ok 
                                                            INNER JOIN tbl_pay_modes m ON ok.mode_id = m.mode_id 
                                                        WHERE ok.key_id IN ($placeholders) AND ok.status = 1 AND m.status = 1
                                                    ");
                $getEventPaymentModes->execute();
                $modes = $getEventPaymentModes->fetchAll();
            }
            return $modes;
        }
        
        public function get_event_plans(){
        	$event = $_POST['event'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE event_id = ? AND status = 1");
            $stmt->execute([$event]);
            $data = $stmt->fetchAll();
            echo json_encode($data);
        }
        
        public function get_plans_online(){
        	$event = $_POST['event'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_ticket_price WHERE event_id = ? AND status = 1 AND post = 1");
            $stmt->execute([$event]);
            
            $info = array();
            $data = $stmt->fetchAll();
            $data2 = $this->get_pay_modes($event);
            
            array_push($info, $data, $data2);
            echo json_encode($info);
        }
        
        function get_agents(){
            $event = $_POST['event'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_events WHERE evt_id = ?");
            $stmt->execute([$event]);
            while($row = $stmt->fetch()) {
                $users = explode(',', trim($row['users'], '[]'));

                $enabledUsers = $users;
                $placeholders = implode(",", $enabledUsers);
                if(empty($placeholders)){
                    $placeholders = 0;
                }

                $getEventUsers = $this->connect->prepare("SELECT account_id, first_name, family_name FROM tbl_users WHERE account_id IN ($placeholders) AND status = 1 AND role_id = 3");
                $getEventUsers->execute();
                $agents = $getEventUsers->fetchAll();
            }
            
            echo json_encode($agents);
        }
    }
    
	$event=new Event();
    $action = $_POST['action'];
	switch($action){
	    case 'register':
	        $event->save_event();
	        break;
	    case 'upload':
	        $event->upload_files();
	        break;
	    case 'update':
	        $event->update_event();
	        break;
	    case 'getoedit':
	        $event->get_event();
	        break;
	    case 'manage':
	        $event->manage_event();
	        break;
	    case 'get_plans':
	        $event->get_event_plans();
	        break;
	    case 'get_plans_online':
	        $event->get_plans_online();
	        break;
	    case 'get_agents':
	        $event->get_agents();
	        break;
	}

?>

