<?php /** Author: @hicode **/ ?>
<?php
    ob_start(); 
    require('../../files/fpdf/fpdf.php');
    require('../../config/connect.php');
    require('../../files/utils/functions.php');

    function doc_header($pdf, $sys, $location, $web, $phone, $email, $event_name, $owner_name){
		$pdf->SetX(150);
		$pdf->SetFont('Times', 'B', 16);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, strtoupper($sys), 0, 0, 'R');
		$pdf->Ln(6);
		
		$pdf->SetFont('Times', 'B', 12);
		$pdf->SetTextColor(0, 0, 0);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, $location, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Website: '.$web, 0, 0, 'R');
		$pdf->Ln(5);
		 
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Tel: '.$phone, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, 'Email: '.$email,0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'Event: '.$event_name, 0, 0, 'L');
		$pdf->Ln(5);
		
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'To: '.$owner_name,0, 0, 'L');
		$pdf->Ln(15);
		
		$pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
		$pdf->Ln();
    }
    //Page footer
    function page_footer($pdf, $syslink){
        $time = date('Y-m-d H:i:s', strtotime('+2hours'));
        $pdf->SetY(-28);
	    $pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
	    $pdf->Ln(1);
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->SetFont('Times', '', 11);
    	$pdf->Cell(12, 6, '');
    	$pdf->SetTextColor(53, 75, 136);
    	$pdf->Cell(125, 6, substr($syslink, 8), 0, 0, 'L');
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->Cell(125, 6, 'GENERATED:  '.$time, 0, 0, 'R');
    	$pdf->Ln();
    } 
    
    $pdf=new FPDF();
    
    $event = $_REQUEST['ev'];
    $agent = $_REQUEST['agent'];
    $total = 0;
    
    $query = $conn->prepare("SELECT ev.*, o.owner_name FROM tbl_events ev INNER JOIN tbl_event_owners o ON ev.owner_id = o.owner_id WHERE ev.evt_id = ?");
    $query->execute([$event]);
    $eventData = $query->fetch();
    
    $query2 = $conn->prepare("SELECT * FROM tbl_users WHERE account_id = ?");
    $query2->execute([$agent]);
    $agentData = $query2->fetch();
    $agentName = $agentData['first_name']." ".$agentData['family_name'];
    
    $pdf->SetAuthor(substr($syslink, 8));
    $pdf->SetTitle('Report - '.$eventData['evtname']);
    $pdf->AddPage('L');
    doc_header($pdf, $sys, $syslocation, $sysweb, $sysphone, $sysemail, $eventData['evtname'], $eventData['owner_name']);

    try {
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetFont('Arial', 'B', 13);
		$pdf->Cell(273, 10, "TICKET SALES REPORT | AGENT: ".$agentName, 0, 0, 'C');
		$pdf->Ln(15);
        $pdf->SetFont('Times', 'B', 12);
        
        $pdf->Cell(12, 6, '');
        $pdf->Cell(25, 6, 'S/N', 1);
        $pdf->Cell(60, 6, 'PLAN', 1);
        $pdf->Cell(40, 6, 'PRICE', 1);
        $pdf->Cell(40, 6, 'POST', 1); 
        $pdf->Cell(40, 6, 'COUNT', 1);
        $pdf->Cell(50, 6, 'TOTAL', 1);
        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
         
        $counter = 1;
        $ticketCount=$conn->prepare("SELECT COUNT(pt.con_tck) AS number, 
                                            pt.post,
                                            tp.price_id,
                                            tp.price_plan,
                                            tp.seats,
                                            pt.amount
                                        FROM tbl_pay_tickets pt 
                                            INNER JOIN tbl_con_tickets c ON pt.con_tck = c.con_tck_id
                                            INNER JOIN tbl_ticket_price tp ON c.price_id = tp.price_id 
                                        WHERE pt.event_id = ? AND pt.userPay = ? GROUP BY tp.price_id, pt.amount
                                    ");
        $ticketCount->execute([$event, $agent]);
        $counter = 1;
        while($tickets = $ticketCount->fetch()){
            $source = "Online";
            if($tickets['post'] == 0){
                $source = "HardC";
            }
            
            $rAmount = $tickets['amount']*($tickets['number']/$tickets['seats']);
            $total += $rAmount;

            $pdf->Cell(12, 6, '');
            $pdf->Cell(25, 6, $counter++, 1);
            $pdf->Cell(60, 6, $tickets['price_plan'], 1);
            $pdf->Cell(40, 6, number_format($tickets['amount']), 1); 
            $pdf->Cell(40, 6, $source, 1); 
            $pdf->Cell(40, 6, number_format($tickets['number']/$tickets['seats']), 1); 
            $pdf->Cell(50, 6, number_format($rAmount), 1); 
            $pdf->Ln();

            if($pdf->GetY()>=175){
                $pdf->AddPage('L');
            }
        }
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell(12, 6, '');
        $pdf->Cell(205, 6, 'Total', 1);
        $pdf->Cell(50, 6, $currency." ".number_format($total, 1), 1); 

        page_footer($pdf, $syslink);
    }catch (PDOException $ex) {
        echo $ex->getMessage();
    }

    $dname = generatefile_v2();
    $pdf->Output($dname.'.pdf','I');
    ob_end_flush();
?>

