<?php /** Author: @hicode **/ ?>
<?php 
include '../../config/connect.php';

?>
<table id="key-listing" class="table d-table">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Event</th>
            <th>Date</th>
            <th>Venue</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $stmt = $conn->prepare("SELECT ev.*, v.long_name
                                        FROM tbl_events ev 
                                            INNER JOIN tbl_venues v ON ev.venue_id = v.venue_id 
                                        WHERE ev.owner_id = ?
                                        ORDER BY ev.start_date ASC");
            $stmt->execute([$_SESSION['account']]);
            $index = 1;
            while($row = $stmt->fetch()) {
        ?>
        <tr class="view" data-id="<?php echo $row['evt_id']; ?>">
            <td><?php echo $index++ ?></td>
            <td><?php echo $row['evtname']; ?></td>
            <td><?php echo $row['start_date']; ?></td>
            <td><?php echo $row['long_name']; ?></td>
            <td>
                <?php if($row['disp'] == 1){ ?>
                <div class="btn badge badge-pill badge-outline-success">Active</div>
                <?php }else{ ?>
                <div class="btn badge badge-pill badge-outline-warning">On hold</div>
                <?php } ?>
            </td>
            <td>
                <div class="d-flex justify-content-between flex-nowrap">
                    <div class="btn badge badge-pill badge-outline-info view" data-id="<?php echo $row['evt_id']; ?>"><span id="spinner_view_<?php echo $row['evt_id']; ?>"></span><i class="fa fa-eye"></i></div>
                </div>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<script>
    $(document).ready(function(){
        $('.d-table').DataTable({
            paging: false
        });
    });
</script>