<?php include '../../config/connect.php'; ?>
<table id="key-listing" class="table d-table">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Event</th>
            <th>Ticket</th>
            <th>Price</th>
            <th>Post</th>
            <th>Count</th>
            <th>Available</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $stmt = $conn->prepare("SELECT ev.evtname, t.*
                                        FROM tbl_ticket_price t 
                                            INNER JOIN tbl_events ev ON t.event_id = ev.evt_id
                                        WHERE 1 ORDER BY t.price_id ASC");
            $stmt->execute();
            $index = 1;
            while($row = $stmt->fetch()) {
                $getGenerated = $conn->prepare("SELECT COUNT(con_tck_id) AS generated FROM tbl_con_tickets WHERE price_id = ?");
                $getGenerated->execute([$row['price_id']]);
                $generated = $getGenerated->fetch();
                $remain = ($row['seats'] * $row['tick_num']) - $generated['generated'];
        ?>
        <tr>
            <td><?php echo $index++ ?></td>
            <td><?php echo $row['evtname']; ?></td>
            <td><?php echo $row['price_plan']; ?></td>
            <td><?php echo $row['price']; ?></td>
            <td>
                <?php if($row['post'] == 1){ ?>
                <div class="btn badge badge-pill badge-outline-success">Online</div>
                <?php }else{ ?>
                <div class="btn badge badge-pill badge-outline-warning">HardC</div>
                <?php } ?>
            </td>
            <td><?php echo number_format($row['tick_num']); ?></td>
            <td><?php echo number_format($remain/$row['seats']); ?></td>
            <td>
                <div class="d-flex justify-content-between flex-nowrap">
                    <div class="btn badge badge-pill badge-outline-info edit" data-id="<?php echo $row['price_id']; ?>"><span id="spinner_edit_<?php echo $row['price_id']; ?>"></span><i class="fa fa-edit"></i></div>&nbsp;
                    <?php if($generated['generated'] > 0){ ?>
                    <div class="btn badge badge-pill badge-outline-danger merge" data-id="<?php echo $row['price_id']; ?>"><span id="spinner_merge_<?php echo $row['price_id']; ?>"></span><i class="fa fa-paperclip"></i></div>&nbsp;
                    <?php } ?>
                    <?php if($remain>0){ ?>
                    <div class="btn badge badge-pill badge-outline-success generate" data-id="<?php echo $row['price_id']; ?>"><span id="spinner_gen_<?php echo $row['price_id']; ?>"></span><i class="fa fa-clipboard"></i></div>&nbsp;
                    <?php } ?>
                    <?php if($generated['generated'] > 0){ ?>
                    <div class="btn badge badge-pill badge-outline-warning manage" data-id="<?php echo $row['price_id']; ?>"><span id="spinner_hold_<?php echo $row['price_id']; ?>"></span><i class="fas fa-cloud-upload-alt"></i></div>
                    <?php } ?>
                </div>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<script>
    $(document).ready(function(){
        $('.d-table').DataTable({
            paging: false
        });
    });
</script>