<?php 
    include '../../../config/connect.php'; 
?>
<table id="key-listing" class="table d-table">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Event</th>
            <th>Ticket</th>
            <th>Agent</th>
            <th>Inventory</th>
            <th>Export</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $stmt = $conn->prepare("SELECT 
                                        DISTINCT(tck.agent_id) AS agent,
                                        us.family_name,
                                        us.first_name,
                                        ev.evtname, 
                                        ev.start_date,
                                        tp.price_id,
                                        tp.event_id,
                                        tp.price_plan
                                        FROM tbl_con_tickets tck 
                                            INNER JOIN tbl_users us ON tck.agent_id = us.account_id AND us.status = 1
                                            INNER JOIN tbl_ticket_price tp ON tck.price_id = tp.price_id AND tp.post = 0
                                            INNER JOIN tbl_events ev ON tck.evt_id = ev.evt_id
                                        WHERE tck.export = 0 ORDER BY ev.start_date ASC");
            $stmt->execute();
            $index = 1;
            while($row = $stmt->fetch()) {
                $getAllGenerated4Agent = $conn->prepare("SELECT COUNT(con_tck_id) AS gen4agent FROM tbl_con_tickets WHERE agent_id = ? AND price_id = ? AND evt_id = ?");
                $getAllGenerated4Agent->execute([$row['agent'], $row['price_id'], $row['event_id']]);
                $generated4Agent = $getAllGenerated4Agent->fetch();
                
                $getAllExported4Agent = $conn->prepare("SELECT COUNT(con_tck_id) AS exp4agent FROM tbl_con_tickets WHERE agent_id = ? AND price_id = ? AND evt_id = ? AND export = 1");
                $getAllExported4Agent->execute([$row['agent'], $row['price_id'], $row['event_id']]);
                $exported4Agent = $getAllExported4Agent->fetch();
                $remain = $generated4Agent['gen4agent'] - $exported4Agent['exp4agent'];
        ?>
        <tr>
            <td><?php echo $index++ ?></td>
            <td><?php echo $row['evtname']; ?></td>
            <td><?php echo $row['price_plan']; ?></td>
            <td><?php echo $row['first_name']." ".$row['family_name']; ?></td>
            <td><?php echo $remain; ?></td>
            <td>
                <div class="d-flex justify-content-between flex-nowrap">
                    <div class="btn badge badge-pill badge-outline-info edit" onclick="OpenPopupCenter('/com/files/tickets/export/export?ev=<?php echo $row['event_id']; ?>&ag=<?php echo $row['agent']; ?>&pl=<?php echo $row['price_id']; ?>', 'Transaction Report', 800, 600);"><i class="fa fa-download"></i></div>
                </div>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<script>
    $(document).ready(function(){
        $('.d-table').DataTable({
            paging: false
        });
    });
</script>