<?php
    include '../../config/connect.php';
    include '../utils/functions.php';
    $connection=$conn;
    class Owner{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function setUserIdentification(){
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users ORDER BY account_id DESC LIMIT 1");
            $stmt->execute();
            $lastUser = $stmt->fetch(); 
            $lastUserIdentification = $lastUser['Identification'];
            return $lastUserIdentification+1;
    	}
    	
    	public function saveUserEntity($name, $password, $email, $phone, $role_id, $Identification){
            $stmt = $this->connect->prepare("INSERT INTO tbl_users(first_name, account_name, account_passwd, email, phone, role_id, Identification) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$name, $phone, $password, $email, $phone, $role_id, $Identification]);
            return;
    	}
    	
    	public function saveOwnerEntity($name, $email, $phone, $identification){
            $stmt = $this->connect->prepare("INSERT INTO tbl_event_owners(owner_name, owner_tel, owner_email, identification) VALUES (?, ?, ?, ?)");
            $stmt->execute([$name, $phone, $email, $identification]);
            return;
    	}
    	
    	public function updateUserEntity($name, $email, $phone, $identification){
            $stmt = $this->connect->prepare("UPDATE tbl_users SET first_name = ?, account_name = ?, email = ?, phone = ? WHERE Identification = ?");
            $stmt->execute([$name, $phone, $email, $phone, $identification]);
            return;
    	}
    	
    	public function updateOwnerEntity($name, $email, $phone, $oid){
            $stmt = $this->connect->prepare("UPDATE tbl_event_owners SET owner_name = ?, owner_email = ?, owner_tel = ? WHERE owner_id = ?");
            $stmt->execute([$name, $email, $phone, $oid]);
            return;
    	}
    	
        public function save_user($name, $email, $phone){
    		global $sys;
    		global $syslink;
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE phone = ?");
            $stmt->execute([$phone]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "User Already exists!");
            }
            else{ 
                $pwd = rand(1000000, 1999999);
                $password = password_hash($pwd, PASSWORD_DEFAULT);
                $identification = $this->setUserIdentification();
                
                $this->saveOwnerEntity($name, $email, $phone, $identification);
                $this->saveUserEntity($name, $password, $email, $phone, 2, $identification);
            
                $message="Dear $name, your account has been created successfuly! Username: $phone | Password: $pwd. Click $syslink to open.";
        
                sendSMS($sys, $phone, $message);
                sendFeedback(200, "Owner created successfully!");
            }
    	}
    	
        public function view_owner(){
        	$oid = $_POST['oid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_event_owners WHERE owner_id = ?");
            $stmt->execute([$oid]);
            $data = $stmt->fetch();
            
            sendDataFeedback($data);
            return;
        }
                
        public function update_user($name, $email, $phone, $oid){
            $stmt0 = $this->connect->prepare("SELECT identification FROM tbl_event_owners WHERE owner_id = ?");
            $stmt0->execute([$oid]);
            $owner_data = $stmt0->fetch();
            $identification = $owner_data['identification'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE phone = ? AND Identification != ?");
            $stmt->execute([$phone, $identification]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "User Already exists!");
            }
            else{ 
                $this->updateOwnerEntity($name, $email, $phone, $oid);
                $this->updateUserEntity($name, $email, $phone, $identification);
            }
            return;
        }
        
        public function save_owner(){
            $name = $_POST['owner_name'];
            $email = $_POST['owner_email'];
            $phone = $_POST['owner_tel'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_event_owners WHERE owner_tel = ?");
            $stmt->execute([$phone]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Owner Already exists!");
            }
            else{ 
                $this->save_user($name, $email, $phone);
            }
    	}
        
        public function update_owner(){
            $oid = $_POST['oid'];    
            $name = $_POST['owner_name'];
            $email = $_POST['owner_email'];
            $phone = $_POST['owner_tel'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_event_owners WHERE owner_tel = ? AND owner_id != ?");
            $stmt->execute([$phone, $oid]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Owner Already exists!");
            }
            else{ 
                $this->update_user($name, $email, $phone, $oid);
                sendFeedback(200, "Owner updated successfully!");
            }
        }
    
    	public function manage_owner(){
            $oid = $_POST['oid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_event_owners WHERE owner_id = ?");
            $stmt->execute([$oid]);
            $prevData = $stmt->fetch();
            if($prevData['status']==1){
                $status=2;
            }
            else{
                $status=1;
            }
            
            $identification = $prevData['identification'];
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_users SET status = ? WHERE Identification = ?");
            $stmt3 = $this->connect->prepare("UPDATE tbl_event_owners SET status = ? WHERE owner_id = ?");
            if($stmt2->execute([$status, $identification]) && $stmt3->execute([$status, $oid])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
    }	
    
	$owner = new Owner();
    $action = $_POST['action'];
	switch($action){
	    case 'register':
	        $owner->save_owner();
	        break;
	    case 'update':
	        $owner->update_owner();
	        break;
	    case 'view':
	        $owner->view_owner();
	        break;
	    case 'manage':
	        $owner->manage_owner();
	        break;
	}

?>

