<?php
include '../../config/connect.php';
include '../utils/functions.php';

$connection = $conn;
class Advert
{
    private $connect;
    public function __construct()
    {
        global $connection;
        $this->connect = $connection;
    }

    ########################### advert Settings ##############################################

    public function saveadvertEntity($ad_name, $start, $until, $type, $banner){
        $stmt = $this->connect->prepare("INSERT INTO tbl_adverts(ad_name, start, until, type, banner) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$ad_name, $start, $until, $type, $banner]);
        return;
    }

    public function updateadvertEntity($ad_id, $ad_name, $start, $until, $type){
        $stmt = $this->connect->prepare("UPDATE tbl_adverts SET ad_id = ?, ad_name = ?, start = ?, until = ?, type = ? WHERE ad_id = ?");
        $stmt->execute([$ad_id, $ad_name, $start, $until, $type, $ad_id]);
        return;
    }

    public function updateadvertFile($file, $ad_id){
        $stmt = $this->connect->prepare("UPDATE tbl_adverts SET banner = ? WHERE ad_id = ?");
        $stmt->execute([$file, $ad_id]);
        return;
    }

    public function save_advert(){
        $ad_name = $_POST['ad_name'];
        $start = $_POST['start'];
        $until = $_POST['until'];
        $type = $_POST['type'];

        $stmt = $this->connect->prepare("SELECT * FROM tbl_adverts WHERE ad_name = ?");
        $stmt->execute([$ad_name]);

        if ($stmt->rowCount() > 0) {
            sendFeedback(400, "advert Already exists!");
        } else {
            if (isset($_FILES['banner'])) {
                $banner = upload_banner($_FILES['banner']);
            } else {
                $banner = "/images/adverts/default.png";
            }

            $this->saveadvertEntity($ad_name, $start, $until, $type, $banner);
            sendFeedback(200, "advert created successfully!");
        }
    }

    public function get_advert(){
        $ad_id = $_POST['ad_id'];
        $stmt = $this->connect->prepare("SELECT * FROM tbl_adverts WHERE ad_id = ?");
        $stmt->execute([$ad_id]);
        $data = $stmt->fetch();
        sendDataFeedback($data);
        return;
    }

    public function update_advert(){
        $ad_id = $_POST['ad_id'];
        $ad_name = $_POST['ad_name'];
        $start = $_POST['start'];
        $until = $_POST['until'];
        $type = $_POST['type'];

        $stmt = $this->connect->prepare("SELECT * FROM tbl_adverts WHERE ad_name = ? AND ad_id != ?");
        $stmt->execute([$ad_name, $ad_id]);

        if ($stmt->rowCount() > 0) {
            sendFeedback(400, "advert Already exists!");
        } else {
            $this->updateadvertEntity($ad_id, $ad_name, $start, $until, $type, $ad_id);
            sendFeedback(200, "advert updated successfully!");
        }
    }
    public function update_advert_file(){
        $ad_id = $_POST['ad_id'];

        if (isset($_FILES['banner'])) {
            $file = upload_banner($_FILES['banner']);
            $this->updateadvertFile($file, $ad_id);
        }

        sendFeedback(200, "advert updated successfully!");
    }

    public function manage_advert(){
        $ad_id = $_POST['ad_id'];
        $stmt = $this->connect->prepare("SELECT * FROM tbl_adverts WHERE ad_id = ?");
        $stmt->execute([$ad_id]);
        $prevData = $stmt->fetch();
        if ($prevData['status'] == 1) {
            $status = 2;
        } else {
            $status = 1;
        }

        $stmt2 = $this->connect->prepare("UPDATE tbl_adverts SET status = ? WHERE ad_id = ?");
        if ($stmt2->execute([$status, $ad_id])) {
            sendFeedback(200, "operation done successfully!");
        } else {
            sendFeedback(400, "operation failed!");
        }
    }
}

$advert = new Advert();
$action = $_POST['action'];
switch ($action) {

        ####### Settings #######
    case 'register':
        $advert->save_advert();
        break;
    case 'update':
        $advert->update_advert();
        break;
    case 'getoedit':
        $advert->get_advert();
        break;
    case 'manage':
        $advert->manage_advert();
        break;
    case 'update_file':
        $advert->update_advert_file();
        break;
}