<?php
    try {
        session_start();
        $_SESSION = array();
        session_destroy();
    }
    catch (PDOException $ex) {		
        echo $ex->getMessage();
    }

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title><?php echo strtoupper(substr($_SERVER["SERVER_NAME"], 2)); ?> | Logout</title>
        <link rel="stylesheet" href="./vendors/iconfonts/font-awesome/css/all.min.css">
        <link rel="stylesheet" href="./vendors/css/vendor.bundle.base.css">
        <link rel="stylesheet" href="./vendors/css/vendor.bundle.addons.css">
        <link rel="stylesheet" href="./css/style.css">
        <link rel="shortcut icon" href="./images/app-logo.png" />
    </head>

    <body>
        <div class="container-scroller">
            <div class="container-fluid page-body-wrapper full-page-wrapper">
                <div class="content-wrapper d-flex align-items-center auth">
                    <div class="row w-100">
                        <div class="col-lg-4 mx-auto">
                            <div class="auth-form-light text-left p-5">
                                <center>
                                    <img src="/images/main-logo.png">
                                </center>
                                <h6 class="text-right">by <a href="https://www.itec.rw" target="_blank">ITEC Ltd.</a></h6>
                                <hr/>
                                <h6 class="text-center">You have been logged out</h6>
                                <p class="text-center">Thank you!</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer class="footer">
            <div class="d-sm-flex justify-content-center justify-content-sm-between">
                <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © <?php echo date("Y"); ?>. All rights reserved.</span>
                <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i> by <a href="https://www.itec.rw" target="_blank">ITEC Ltd.</a></span>
            </div>
        </footer>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="./js/auth/script.js"></script>
        <script src="./vendors/js/vendor.bundle.base.js"></script>
        <script src="./vendors/js/vendor.bundle.addons.js"></script>
        <script src="./js/off-canvas.js"></script>
        <script src="./js/hoverable-collapse.js"></script>
        <script src="./js/misc.js"></script>
        <script src="./js/settings.js"></script>
        <script src="./js/todolist.js"></script>
        <script src="./js/toastDemo.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function(){
                setTimeout(function(){
                    var linkUrl = '/';
                    location.href = linkUrl;
                }, 5000);
            });
         </script>
    </body>
</html>