<?php
    function sendFeedback($s, $m){
        $data = array("status"=>$s,"message" => $m);
        $jsonData = json_encode($data);
        echo $jsonData; 
    }
    function requestPurchaseCode($amount, $key, $email){
        try {
            $data = array(
                'amount' => $amount,
                'email' => $email,
                'key' => $key
            );
                
            $jsonData = json_encode($data);

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, 'https://pay.itecpay.rw/api/pay/apis/pesapal/generatecode');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                
            $response = curl_exec($curl);
                
            if (curl_errno($curl)) {
                $error = curl_error($curl);
            }
                
            curl_close($curl);

            return $response;    
        } catch (Exception $error) {
            return sendFeedback(400, "something went wrong, retry!");
        }
    }
    
    function saveAndRedirect($access, $PCODE, $event, $plan, $ticket_count, $email, $phone, $holder, $link){
        $sql = $access->prepare("INSERT INTO tbl_purchase_codes(PCODE, event_id, price_id, tcount, email, phone, names) VALUES (?, ?, ?, ?, ?, ?, ?)");
        if($sql->execute([$PCODE, $event, $plan, $ticket_count, $email, $phone, $holder])){
            sendFeedback(307, $link);
            exit();
        }else{
            sendFeedback(400, "something went wrong, retry!");
        }
    }
    
    function doPayment($amount, $key, $phone){
        try {
            $data = array(
                'amount' => $amount,
                'phone' => $phone,
                'key' => $key
            );
                
            $jsonData = json_encode($data);

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, 'https://pay.itecpay.rw/api/pay');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                
            $response = curl_exec($curl);
                
            if (curl_errno($curl)) {
                $error = curl_error($curl);
            }
                
            curl_close($curl);
                
            $responseData = json_decode($response, true);
            return $responseData;    
        } catch (Exception $error) {
            sendFeedback(400, "something went wrong, retry!");
        }
    }
    function doPayment2($amount, $key, $phone){
        try {
            $data = array(
                'amount' => $amount,
                'phone' => $phone,
                'key' => $key
            );
                
            $jsonData = json_encode($data);

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, 'https://pay.itecpay.rw/api2/pay');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                
            $response = curl_exec($curl);
                
            if (curl_errno($curl)) {
                $error = curl_error($curl);
            }
                
            curl_close($curl);
            // check for null response
            if($response == null){
                return array();
            }
                
            $responseData = json_decode($response, true);
            return $responseData;    
        } catch (Exception $error) {
            sendFeedback(400, "something went wrong, retry!");
        }
    }

    
    function getPaymentKey($pmode, $access){
        $stmt = $access->query("SELECT mode_id, ipay_key FROM tbl_owner_keys WHERE key_id = $pmode");
        if($stmt->rowCount()>0){
            $key = $stmt->fetch();
            return $key;
        }
        return NULL;
    } 
    
    function validateRequest($event, $plan, $pmode, $access){
        $stmt = $access->query("SELECT evt_id FROM tbl_events WHERE evt_id = $event AND disp = 1");
        if($stmt->rowCount() == 0){
            return false;
        }
        
        $stmt2 = $access->query("SELECT price_id FROM tbl_ticket_price WHERE price_id = $plan AND event_id = $event AND post = 1");
        if($stmt2->rowCount() == 0){
            return false;
        } 
        $pmode_json = json_encode((string) $pmode);
        
        $stmt3 = $access->prepare('SELECT evt_id FROM tbl_events WHERE evt_id = ? AND JSON_CONTAINS(pay_modes, ?)');
        $stmt3->execute([$event, $pmode_json]);
        if($stmt3->rowCount() == 0){
            return false;
        }
        
        return true;
    }
    
    function getPlanAmount($plan, $access){
        $stmt = $access->query("SELECT price FROM tbl_ticket_price WHERE price_id = $plan");
        if($stmt->rowCount()>0){
            $planData = $stmt->fetch();
            return $planData['price'];
        }
        
        return 0;
    }
    
    function getPurchaseCodeData($access, $PCODE){
        $stmt = $access->prepare("SELECT * FROM tbl_purchase_codes WHERE PCODE = ? AND status = 1");
        $stmt->execute([$PCODE]);
        if($stmt->rowCount() == 0){
            return false;
        }
        
        return $stmt->fetch();
    }
    
    function invalidatePCODE($access, $PCODE){
        $stmt = $access->prepare("DELETE FROM tbl_purchase_codes WHERE PCODE = ?");
        $stmt->execute([$PCODE]);
        return;
    }
?>
