<?php /** Author: @hicode **/ ?>
<div class="content-wrapper">
    <div class="page-header">
        <h3 class="page-title"><?php echo $title; ?></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="?access=home"><?php echo $sys; ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $title; ?></li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                        <a class="nav-link active" id="list-tab" data-toggle="tab" href="#list-1" role="tab" aria-controls="list-1" aria-selected="true">List</a>
                        </li>
                        <li class="nav-item">
                        <a class="nav-link" id="add-tab" data-toggle="tab" href="#add-1" role="tab" aria-controls="add-1" aria-selected="false">Add</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="list-1" role="tabpanel" aria-labelledby="list-tab">
                            <div class="table-responsive"  id="users">
                                <div class="loader-demo-box">
                                    <div class="bar-loader">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="add-1" role="tabpanel" aria-labelledby="add-tab">
                            <div class="grid-margin stretch-card">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title">Register new User</h4>
                                        <form class="forms-sample" id="userRegistry" action="" method="POST" autocomplete="off">
                                            <input type="hidden" name="action" value="register">
                                            <div class="row">
                                                <div class="col-md-6 form-group"> 
                                                    <label>First Name</label>
                                                    <input type="text" class="form-control" name="first_name" placeholder="First name" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Family Name</label>
                                                    <input type="text" class="form-control" name="family_name" placeholder="Family name" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Email</label>
                                                    <input type="email" class="form-control" name="email" placeholder="Email" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Phone</label>
                                                    <input type="text" class="form-control" name="phone" id="user_phone" maxlength="13" minlength="8" oninput="cleanPhoneNumber(this)" placeholder="Phone" required>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Gender</label>
                                                    <select class="form-control" name="gender" required>
                                                        <option value="M">Male</option>
                                                        <option value="F">Female</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label>Role</label>
                                                    <select class="form-control" name="role_id" required>
                    									<?php
                                        					$stmt = $conn->prepare("SELECT *  FROM tbl_user_roles WHERE role_id != 1");
                                        					$stmt->execute();
                                        					while ($row = $stmt->fetch()) { 
                                        				?>
                                                        <option value="<?php echo $row['role_id']; ?>"><?php echo $row['role'];?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <button type="submit" class="btn btn-primary mr-2"><span id="spinner"></span>&nbsp;<span id="indicator">Submit</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form class="forms-sample" id="userUpdate" action="" method="POST" autocomplete="off">
    <div class="modal fade " id="editModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">User update</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="update">
                    <input type="hidden" name="uid" id="uid">
                    <div class="row">
                        <div class="col-md-6 form-group"> 
                            <label>First Name</label>
                            <input type="text" class="form-control" name="first_name" id="first_name" placeholder="First name" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Family Name</label>
                            <input type="text" class="form-control" name="family_name" id="family_name" placeholder="Family name" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" name="email" id="email" placeholder="Email" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Phone</label>
                            <input type="text" class="form-control" name="phone" id="phone" maxlength="13" minlength="10" oninput="cleanPhoneNumber(this)" placeholder="Phone" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Gender</label>
                            <select class="form-control" name="gender" id="gender" required>
                                <option value="M">Male</option>
                                <option value="F">Female</option>
                            </select>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Role</label>
                            <select class="form-control" name="role_id" id="role_id" required>
								<?php
                					$stmt = $conn->prepare("SELECT *  FROM tbl_user_roles WHERE role_id != 1");
                					$stmt->execute();
                					while ($row = $stmt->fetch()) { 
                				?>
                                <option value="<?php echo $row['role_id']; ?>"><?php echo $row['role'];?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><span id="spinner2"></span>&nbsp;<span id="indicator2">Save changes</span></button>
                    <button type="button" class="btn btn-light" data-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php include '../files/users/scripts.php' ?>