<?php /** Author: @hicode **/ ?>
<?php
    include '../../config/connect.php';
    include '../utils/functions.php';
    $connection=$conn;
    class User{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function setUserIdentification(){
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users ORDER BY account_id DESC LIMIT 1");
            $stmt->execute();
            $lastUser = $stmt->fetch(); 
            $lastUserIdentification = $lastUser['Identification'];
            return $lastUserIdentification+1;
    	}
    	
    	public function saveUserEntity($family_name, $first_name, $password, $email, $phone, $role_id, $gender, $Identification){
            $stmt = $this->connect->prepare("INSERT INTO tbl_users(family_name, first_name, account_name, account_passwd, email, phone, role_id, gender, Identification) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$family_name, $first_name, $phone, $password, $email, $phone, $role_id, $gender, $Identification]);
            return;
    	}
    	
    	public function updateUserEntity($family_name, $first_name, $email, $phone, $role, $gender, $uid){
            $stmt = $this->connect->prepare("UPDATE tbl_users SET family_name = ?, first_name = ?, account_name = ?, email = ?, phone = ?, role_id = ?, gender = ? WHERE account_id = ?");
            $stmt->execute([$family_name, $first_name, $phone, $email, $phone, $role, $gender, $uid]);
            return;
    	}
    	
        public function save_user(){
            $first_name = $_POST['first_name'];
            $family_name = $_POST['family_name'];
            $email = $_POST['email'];
            $phone = $_POST['phone'];
            $gender = $_POST['gender'];
            $role = $_POST['role_id'];
    		global $sys;
    		global $syslink;
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE phone = ?");
            $stmt->execute([$phone]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "User Already exists!");
            }
            else{ 
                $pwd = rand(1000000, 1999999);
                $password = password_hash($pwd, PASSWORD_DEFAULT);
                $identification = $this->setUserIdentification();
                
                $this->saveUserEntity($family_name, $first_name, $password, $email, $phone, $role, $gender, $identification);
            
                $message="Dear $first_name, your account has been created successfuly! Username: $phone | Password: $pwd. Click $syslink to open.";
        
                sendSMS($sys, $phone, $message);
                sendFeedback(200, "Account created successfully!");
            }
    	}
    	
        public function view_user(){
        	$uid = $_POST['uid'];
            $stmt = $this->connect->prepare("SELECT account_id, family_name, first_name, email, phone, role_id, gender FROM tbl_users WHERE account_id = ?");
            $stmt->execute([$uid]);
            $data = $stmt->fetch();
            
            sendDataFeedback($data);
            return;
        }
                
        public function update_user(){
            $uid = $_POST['uid'];    
            $first_name = $_POST['first_name'];
            $family_name = $_POST['family_name'];
            $email = $_POST['email'];
            $phone = $_POST['phone'];
            $gender = $_POST['gender'];
            $role = $_POST['role_id'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE phone = ? AND account_id != ?");
            $stmt->execute([$phone, $uid]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "User Already exists!");
            }
            else{ 
                $this->updateUserEntity($family_name, $first_name, $email, $phone, $role, $gender, $uid);
                sendFeedback(200, "Account updated successfully!");
            }
        }
    
    	public function manage_user(){
            $uid = $_POST['uid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_users WHERE account_id = ?");
            $stmt->execute([$uid]);
            $prevData=$stmt->fetch();
            if($prevData['status']==1){
                $status=2;
            }
            else{
                $status=1;
            }
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_users SET status = ? WHERE account_id = ?");
            if($stmt2->execute([$status, $uid])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
    }
    
	$user=new User();
    $action = $_POST['action'];
	switch($action){
	    case 'register':
	        $user->save_user();
	        break;
	    case 'update':
	        $user->update_user();
	        break;
	    case 'view':
	        $user->view_user();
	        break;
	    case 'manage':
	        $user->manage_user();
	        break;
	}

?>

