<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function validatePhoneNumber(phone) {
        var pattern = /^07[89]\d{7}$/;
        if (pattern.test(phone.trim())) {
            return true;
        }else{
            return false;
        }
    }
    
    function cleanPhoneNumber(input) {
        var phoneNumber = input.value;
        var cleanedPhoneNumber = phoneNumber.replace(/[^+0-9]/g, "");
        input.value = cleanedPhoneNumber;
    } 
   
    function fetch_data(){
        $.ajax({
            url: "/com/files/owners/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#owners').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#owners').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();
        $("#ownerRegistry").submit(function(e){
            e.preventDefault();
            
            if(!validatePhoneNumber($("#owner_tel_verify").val())){
                showInfoToast("Please enter a valid phone number starting with 078 or 079");
                return;
            }  
            var formdata = new FormData(this);
            $("#ownerRegistry :input").prop("disabled", true);
            $('#spinner').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator').html("Processing");
            $.ajax({
                url: "/com/files/owners/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    if(data.status==200){
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                    $("#ownerRegistry :input").prop("disabled", false);
                },error: function(){
                    $('#spinner').hide();
                    $('#indicator').html("Register");
                    $("#ownerRegistry :input").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                oid : identifier,
                action : 'view'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/owners/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#owner_name").val(data.owner_name);
                    $("#owner_email").val(data.owner_email);
                    $("#owner_tel").val(data.owner_tel);
                    $("#oid").val(data.owner_id);
                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $("#ownerUpdate").submit(function(e){
            e.preventDefault();

            if(!validatePhoneNumber($("#owner_tel").val())){
                showInfoToast("Please enter a valid phone number starting with 078 or 079");
                return;
            }  

            var formdata = new FormData(this);
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing");
            $.ajax({
                url: "/com/files/owners/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                contentType: false,
                cache: false,
                processData: false,
                success: function(data){
                    $('#spinner2').hide();
                    $('#indicator2').html("Save changes");
                    if(data.status==200){
                        $("#editModal").modal('hide');
                        showSuccessToast(data.message);
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },error: function(){
                    $('#spinner2').hide();
                    $('#indicator2').html("Register");
                    showWarningToast("Something went wrong!");
                }
            });
        });
        
        // manage owners
        $(document).on('click','.manage',function(){
            var identifier = $(this).data('id');
            var formdata = {
                oid : identifier,
                action : 'manage'
            };
            swal({
                title: "Are you sure?",
                text: "This can't be undone!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $(".manage").prop("disabled", true);
                    $('#spinner_hold_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
                    $.ajax({
                        url: "/com/files/owners/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        cache: false,
                        success: function(data){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            if(data.status==200){
                                showSuccessToast(data.message);
                                fetch_data();
                            }else{
                                showInfoToast(data.message);
                            }
                        },error: function(){
                            $('#spinner_hold_' + identifier).hide();
                            $(".manage").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                }
                else {
                    swal("operation Cancelled!!");
                }
            });
        });
    });
    
 </script>