<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function fetch_data(){
        $.ajax({
            url: "/com/files/evusers/fetch_data.php",
            type: "GET",
            mimeTypes: "multipart/form-data",
            contentType: false,
            processData: false,
            cache: false,
            success: function(data){
                $(".loader-demo-box").remove();
                $('#evusers').html(data);
            },error: function(){
                $(".loader-demo-box").remove();
                showWarningToast("Something went wrong!");
                $('#evusers').hide();
            }
        }); 
    }
    
    $(document).ready(function(){
        fetch_data();

        // edit mode data retrieval
        $(document).on('click','.edit',function(){
            var identifier = $(this).data('id');
            var formdata = {
                evt_id : identifier,
                action : 'getoedit'
            };
            $(".edit").prop("disabled", true);
            $('#spinner_edit_' + identifier).html("<img src='/images/ajax-loader.gif' width='15'> ").fadeIn('fast');
            $.ajax({
                url: "/com/files/evusers/controller.php",
                type: "POST",
                data: formdata,
                dataType: "JSON",
                cache: false,
                success: function(data){
                    $(".edit").prop("disabled", false);
                    $('#spinner_edit_' + identifier).hide();
                    $("#evt_id").val(data[0].evt_id);
                    $("#evtname").html(data[0].evtname);
                    $("#event_desc").html(data[0].event_desc);
                    
                    var html='';
                    $('#users').html("");
                    if(data[1].length>0){
                        data[1].forEach(function(user) {
                            html += '<tr>';
                            if(data[0].users != null && data[0].users.includes(user.account_id)){
                                html += '<td><input type="checkbox" class="form-control" style="width:15px;height:15px" name="users[]" value="'+user.account_id+'" checked></td>';
                            }else{
                                html += '<td><input type="checkbox" class="form-control" style="width:15px;height:15px" name="users[]" value="'+user.account_id+'"></td>';    
                            }
                            html += '<td>'+user.first_name+' '+user.family_name+'</td>';
                            html += '<td>'+user.role+'</td>';
                            html += '</tr>';
                        });
                        $('#users').html(html);
                    }

                    $("#editModal").modal('show');
                },error: function(){
                    $('#spinner_edit_' + identifier).hide();
                    $(".edit").prop("disabled", false);
                    showWarningToast("Something went wrong!");
                }
            });
        });

        // update script
        $('#eventUpdate').submit(function(e) {
            e.preventDefault();
            $('#spinner2').html("<img src='/images/ajax-loader.gif' width='15'>").fadeIn('fast');
            $('#indicator2').html("Processing...");
            
            var formdata = new FormData(this);
            $('#eventUpdate').attr('disabled',true);
            
            $.ajax({
                url: '/com/files/evusers/controller.php',
                type: 'POST',
                data: formdata,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#eventUpdate').attr('disabled', false);
                    
                    if(data.status==200){
                        showSuccessToast(data.message);
                        $("#editModal").modal('hide');
                        fetch_data();
                    }else{
                        showInfoToast(data.message);
                    }
                },
                error: function(error) {
                    $('#spinner2').fadeOut('fast');
                    $('#indicator2').html("Save changes");
                    $('#eventUpdate').attr('disabled', false);
                    showWarningToast("Something went wrong!");
                }
            });
        });
    });
    
 </script>