<?php /** Author: @hicode **/ ?>
<?php include '../config/connect.php'; ?>
<?php ini_set('log_errors', 0); ?>
<?php
    $event = $_POST['event'];
?>
<h4 class="card-title"><i class="icon-sm fa fa-check-circle mr-2"></i>Event Analytics</h4>
<div class="row">
    <?php
        $query = "SELECT * FROM tbl_ticket_price WHERE event_id = ?";
        $plans = $conn->prepare($query);
        $plans->execute([$event]);
    
        while($plan = $plans->fetch()){
            $source = "online";
            if($plan['post'] == 0){
                $source = "hardC";
            }
            
            $salesData = $conn->prepare("SELECT  
                                            COUNT(p.con_tck) AS sold_count, 
                                            COALESCE(SUM(p.amount), 0) AS amount 
                                        FROM tbl_pay_tickets p
                                            LEFT JOIN tbl_con_tickets c ON p.con_tck = c.con_tck_id
                                        WHERE p.event_id = ? AND c.price_id = ? AND userPay = ?");
            $salesData->execute([$event, $plan['price_id'], $_SESSION['account']]);
            
            $salesData = $salesData->fetch();
            $sales = $salesData['sold_count'];
            $revenue = $salesData['amount'];
            

            
    ?>
    <div class="col-md-4 grid-margin stretch-card">
        <div class="card">
            <div class="card-body d-flex flex-column">
                <h4 class="card-title"> <i class="fas fa-tachometer-alt"></i> <?php echo $plan['price_plan']; ?> </h4>
                <div class="flex-grow-1 d-flex flex-column justify-content-between">
                <div class="pt-4">
                    <div id="sales-status-chart-legend" class="sales-status-chart-legend">
                        <ul class="legend2">
                            <li>
                                <span class="legend-label" style="background-color:#ff5e6d"></span><?php echo $source; ?>
                            </li> 
                            <li>
                                <span class="legend-label" style="background-color:#04b76b"></span>Sold<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($sales); ?></label>
                            </li>
                            <li>
                                <span class="legend-label" style="background-color:#0b94f7"></span>Revenue<label class="badge badge-light badge-pill legend-percentage ml-auto"><?php echo number_format($revenue)." ".$currency; ?></label>
                            </li>
                        </ul>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>