<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title><?php echo strtoupper(substr($_SERVER["SERVER_NAME"], 2)); ?> | Login</title>
        <link rel="stylesheet" href="./vendors/iconfonts/font-awesome/css/all.min.css">
        <link rel="stylesheet" href="./vendors/css/vendor.bundle.base.css">
        <link rel="stylesheet" href="./vendors/css/vendor.bundle.addons.css">
        <link rel="stylesheet" href="./css/style.css">
        <link rel="shortcut icon" href="./images/app-logo.png" />
    </head>

    <body>
        <div class="container-scroller">
            <div class="container-fluid page-body-wrapper full-page-wrapper">
                <div class="content-wrapper d-flex align-items-center auth">
                    <div class="row w-100">
                        <div class="col-lg-4 mx-auto">
                            <div class="auth-form-light text-left p-5">
                                <center>
                                    <img src="/images/main-logo.png">
                                </center>
                                
                                <!--<h2 class="text-right"><?php echo strtoupper(substr($_SERVER["SERVER_NAME"], 2)); ?></h2>-->
                                <h6 class="text-right">by <a href="https://www.itec.rw" target="_blank">ITEC Ltd.</a></h6>
                                <hr/>
                                <h6 class="font-weight-light">Sign in to continue.</h6>
                                <form class="pt-3" id="Auth" action="" autocomplete="off">
                                    <input type="hidden" name="action" value="auth">
                                    <div class="form-group">
                                        <input type="text" name="username" class="form-control form-control-lg" placeholder="Username">
                                    </div>
                                    <div class="form-group">
                                        <input type="password" name="passcode" class="form-control form-control-lg" placeholder="Password">
                                    </div>
                                    <div class="mt-3">
                                        <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn"><span id="spinner"></span>&nbsp;<span id="indicator">SIGN IN</span></a>
                                    </div>
                                    <div class="my-2 d-flex justify-content-end align-items-center">
                                        <a href="/reset_password" class="auth-link text-black">Forgot password?</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer class="footer">
            <div class="d-sm-flex justify-content-center justify-content-sm-between">
                <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © <?php echo date("Y"); ?>. All rights reserved.</span>
                <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i> by <a href="https://www.itec.rw" target="_blank">ITEC Ltd.</a></span>
            </div>
        </footer>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="./js/auth/script.js"></script>
        <script src="./vendors/js/vendor.bundle.base.js"></script>
        <script src="./vendors/js/vendor.bundle.addons.js"></script>
        <script src="./js/off-canvas.js"></script>
        <script src="./js/hoverable-collapse.js"></script>
        <script src="./js/misc.js"></script>
        <script src="./js/settings.js"></script>
        <script src="./js/todolist.js"></script>
        <script src="./js/toastDemo.js"></script>
        <script>
            $(document).ready(function(){
                $("#Auth").submit(function(e){
                    e.preventDefault();
                    var formdata = new FormData(this);
                    $("#Auth").prop("disabled", true);
                    $('#spinner').html("<img src='./images/ajax-loader.gif' width='17'> ").fadeIn('fast');
                    $('#indicator').html("Connecting...");
                    $.ajax({
                        url: "./auth/controller.php",
                        type: "POST",
                        data: formdata,
                        dataType: "JSON",
                        processData: false,
                        contentType: false,
                        cache: false,
                        success: function(data){
                            $("#Auth").prop("disabled", false);
                            $('#spinner').hide();
                            $('#indicator').html("SIGN IN");
                            if(data.status == 200){
                                showSuccessToast(data.message);
                                setTimeout(function(){
                                    window.location.href = "/com/config/access";
                                }, 2000);
                                
                            }else{
                                showDangerToast(data.message);
                            }
                        },error: function(){
                            $('#spinner').hide();
                            $('#indicator').html("SIGN IN");
                            $("#Auth").prop("disabled", false);
                            showWarningToast("Something went wrong!");
                        }
                    });
                });
            });
        </script>
        <script>
            // Disable right-click
            document.addEventListener('contextmenu', function (e) {
                e.preventDefault();
            });
            
            // Disable keyboard shortcuts
            document.addEventListener('keydown', function (e) {
                if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C')) || (e.ctrlKey && e.key === 'U')) {
                    e.preventDefault();
                }
            });
        </script>
    </body>
</html>
