(function($) {
  showSuccessToast = function(textToDisplay) {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Success',
      text: textToDisplay,
      showHideTransition: 'slide',
      icon: 'success',
      loaderBg: '#f96868',
      position: 'top-center'
    })
  };
  showInfoToast = function(textToDisplay) {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Info',
      text: textToDisplay,
      showHideTransition: 'slide',
      icon: 'info',
      loaderBg: '#46c35f',
      position: 'top-center'
    })
  };
  showWarningToast = function(textToDisplay) {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Connection failed',
      text: textToDisplay,
      showHideTransition: 'slide',
      icon: 'warning',
      loaderBg: '#57c7d4',
      position: 'top-center'
    })
  };
  showDangerToast = function(textToDisplay) {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Oops',
      text: textToDisplay,
      showHideTransition: 'slide',
      icon: 'error',
      loaderBg: '#FF5E6D',
      position: 'top-center'
    })
  };
  showToastPosition = function(position) {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Positioning',
      text: 'Specify the custom position object or use one of the predefined ones',
      position: String(position),
      icon: 'info',
      stack: false,
      loaderBg: '#f96868'
    })
  }
  showToastInCustomPosition = function() {
    'use strict';
    resetToastPosition();
    $.toast({
      heading: 'Custom positioning',
      text: 'Specify the custom position object or use one of the predefined ones',
      icon: 'info',
      position: {
        left: 120,
        top: 120
      },
      stack: false,
      loaderBg: '#f96868'
    })
  }
  resetToastPosition = function() {
    $('.jq-toast-wrap').removeClass('bottom-left bottom-right top-left top-right mid-center'); // to remove previous position class
    $(".jq-toast-wrap").css({
      "top": "",
      "left": "",
      "bottom": "",
      "right": ""
    }); //to remove previous position style
  }
})(jQuery);