<?php /** Author: @hicode **/ ?>
<?php
    ob_start(); 
    require('../../files/fpdf/fpdf.php');
    require('../../config/connect.php');
    require('../../files/utils/functions.php');

    function doc_header($pdf, $sys, $location, $web, $phone, $email, $event_name, $owner_name){
		$pdf->SetX(150);
		$pdf->SetFont('Times', 'B', 16);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, strtoupper($sys), 0, 0, 'R');
		$pdf->Ln(6);
		
		$pdf->SetFont('Times', 'B', 12);
		$pdf->SetTextColor(0, 0, 0);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, $location, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Website: '.$web, 0, 0, 'R');
		$pdf->Ln(5);
		 
		$pdf->SetX(150);
		$pdf->Cell(120, 5, 'Tel: '.$phone, 0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetX(150);
		$pdf->SetTextColor(53, 75, 136);
		$pdf->Cell(120, 5, 'Email: '.$email,0, 0, 'R');
		$pdf->Ln(5);
		
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'Event: '.$event_name, 0, 0, 'L');
		$pdf->Ln(5);
		
		$pdf->SetX(12);
		$pdf->Cell(120, 5, 'To: '.$owner_name,0, 0, 'L');
		$pdf->Ln(15);
		
		$pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
		$pdf->Ln();
    }
    //Page footer
    function page_footer($pdf, $syslink){
        $time = date('Y-m-d H:i:s', strtotime('+2hours'));
        $pdf->SetY(-28);
	    $pdf->Line(0, $pdf->GetY(), $pdf->GetPageWidth(), $pdf->GetY());
	    $pdf->Ln(1);
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->SetFont('Times', '', 11);
    	$pdf->Cell(12, 6, '');
    	$pdf->SetTextColor(53, 75, 136);
    	$pdf->Cell(125, 6, substr($syslink, 8), 0, 0, 'L');
    	$pdf->SetTextColor(0, 0, 0);
    	$pdf->Cell(125, 6, 'GENERATED:  '.$time, 0, 0, 'R');
    	$pdf->Ln();
    } 
    
    $pdf=new FPDF();
    
    $event = $_REQUEST['ev'];
    $type = $_REQUEST['rep'];
    $total = 0;
    
    $query = $conn->prepare("SELECT ev.*, o.owner_name FROM tbl_events ev INNER JOIN tbl_event_owners o ON ev.owner_id = o.owner_id WHERE ev.evt_id = ?");
    $query->execute([$event]);
    $eventData = $query->fetch();
    
    $pdf->SetAuthor(substr($syslink, 8));
    $pdf->SetTitle('Report - '.$eventData['evtname']);
    $pdf->AddPage('L');
    doc_header($pdf, $sys, $syslocation, $sysweb, $sysphone, $sysemail, $eventData['evtname'], $eventData['owner_name']);

    try {
        switch($type){
            case 1:
                {
            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "GENERAL TICKET SALES REPORT", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(75, 6, 'TICKET', 1); 
                    $pdf->Cell(50, 6, 'SOURCE', 1); 
                    $pdf->Cell(65, 6, 'SOLD', 1);
                    $pdf->Cell(50, 6, 'AMOUNT', 1); 
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    $stmt = $conn->prepare("SELECT price_id, price_plan, post FROM tbl_ticket_price WHERE event_id = ?");
                    $stmt->execute([$event]);
                    
                    $counter = 0;
                    $pager = $stmt->rowCount();
                    $index = 1;
                    while($row = $stmt->fetch()) {
                        $source = "HardC";
                        if($row['post'] == 1){
                            $source = "Online";
                        }
                        $stmt2 = $conn->prepare("
                                                SELECT  
                                                    COUNT(p.con_tck) AS sold_count, 
                                                    COALESCE(SUM(p.amount), 0) AS amount 
                                                FROM tbl_pay_tickets p
                                                    LEFT JOIN tbl_con_tickets c ON p.con_tck = c.con_tck_id
                                                WHERE p.event_id = ? AND c.price_id = ?");
                        $stmt2->execute([$event, $row['price_id']]);
                        $sales = $stmt2->fetch();
                        $total += $sales['amount'];
        
                        $pdf->Cell(12, 6, '');
                        $pdf->Cell(25, 6, $index++, 1);
                        $pdf->Cell(75, 6, $row['price_plan'], 1);
                        $pdf->Cell(50, 6, $source, 1); 
                        $pdf->Cell(65, 6, number_format($sales['sold_count']), 1); 
                        $pdf->Cell(50, 6, number_format($sales['amount']), 1); 
                        $pdf->Ln();
                        $counter++;
                        if($pdf->GetY()>=175 && $counter<=$pager){
                            $pdf->AddPage('L');
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(215, 6, 'Total', 1);
                    $pdf->Cell(50, 6, $currency." ".number_format($total), 1); 
                }
                break;
                
            case 2:
                {
                    $stmt = $conn->prepare("SELECT price_id, price_plan FROM tbl_ticket_price WHERE event_id = ? AND post = 1");
                    $stmt->execute([$event]);

            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "ONLINE TICKET SALES REPORT", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(90, 6, 'TICKET', 1);
                    $pdf->Cell(80, 6, 'SOLD', 1);
                    $pdf->Cell(70, 6, 'AMOUNT', 1); 
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    $counter = 0;
                    $pager = $stmt->rowCount();
                    $index = 1;
                    while($row = $stmt->fetch()) {
                        $stmt2 = $conn->prepare("
                                                SELECT  
                                                    COUNT(p.con_tck) AS sold_count, 
                                                    COALESCE(SUM(p.amount), 0) AS amount 
                                                FROM tbl_pay_tickets p
                                                    LEFT JOIN tbl_con_tickets c ON p.con_tck = c.con_tck_id
                                                WHERE p.event_id = ? AND c.price_id = ?");
                        $stmt2->execute([$event, $row['price_id']]);
                        $sales = $stmt2->fetch();
                        $total += $sales['amount'];
        
                        $pdf->Cell(12, 6, '');
                        $pdf->Cell(25, 6, $index++, 1);
                        $pdf->Cell(90, 6, $row['price_plan'], 1);
                        $pdf->Cell(80, 6, number_format($sales['sold_count']), 1); 
                        $pdf->Cell(70, 6, number_format($sales['amount']), 1); 
                        $pdf->Ln();
                        $counter++;
                        if($pdf->GetY()>=175 && $counter<=$pager){
                            $pdf->AddPage('L');
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(195, 6, 'Total', 1);
                    $pdf->Cell(70, 6, $currency." ".number_format($total), 1); 
                }
                break;
                
            case 3:
                {
                    $stmt = $conn->prepare("SELECT price_id, price_plan FROM tbl_ticket_price WHERE event_id = ? AND post = 0");
                    $stmt->execute([$event]);

            		$pdf->SetTextColor(0, 0, 0);
            		$pdf->SetFont('Arial', 'B', 13);
            		$pdf->Cell(273, 10, "HARD COPY TICKET SALES REPORT", 0, 0, 'C');
            		$pdf->Ln(15);
                    $pdf->SetFont('Times', 'B', 12);
                    
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(25, 6, 'S/N', 1);
                    $pdf->Cell(90, 6, 'TICKET', 1);
                    $pdf->Cell(80, 6, 'SOLD', 1);
                    $pdf->Cell(70, 6, 'AMOUNT', 1); 
                    $pdf->Ln();
                    $pdf->SetFont('Times', '', 12);
                    
                    $counter = 0;
                    $pager = $stmt->rowCount();
                    $index = 1;
                    while($row = $stmt->fetch()) {
                        $stmt2 = $conn->prepare("
                                                SELECT  
                                                    COUNT(p.con_tck) AS sold_count, 
                                                    COALESCE(SUM(p.amount), 0) AS amount 
                                                FROM tbl_pay_tickets p
                                                    LEFT JOIN tbl_con_tickets c ON p.con_tck = c.con_tck_id
                                                WHERE p.event_id = ? AND c.price_id = ?");
                        $stmt2->execute([$event, $row['price_id']]);
                        $sales = $stmt2->fetch();
                        $total += $sales['amount'];
        
                        $pdf->Cell(12, 6, '');
                        $pdf->Cell(25, 6, $index++, 1);
                        $pdf->Cell(90, 6, $row['price_plan'], 1);
                        $pdf->Cell(80, 6, number_format($sales['sold_count']), 1); 
                        $pdf->Cell(70, 6, number_format($sales['amount']), 1); 
                        $pdf->Ln();
                        $counter++;
                        if($pdf->GetY()>=175 && $counter<=$pager){
                            $pdf->AddPage('L');
                        }
                    }
                    $pdf->SetFont('Times', 'B', 12);
                    $pdf->Cell(12, 6, '');
                    $pdf->Cell(195, 6, 'Total', 1);
                    $pdf->Cell(70, 6, $currency." ".number_format($total), 1); 
                }
                break;
            
            default:
                {
                    
                }
            break;
        }

        page_footer($pdf, $syslink);
    }catch (PDOException $ex) {
        echo $ex->getMessage();
    }

    $dname = generatefile_v2();
    $pdf->Output($dname.'.pdf','I');
    ob_end_flush();
?>

