<?php
    include '../../config/connect.php';
    include '../utils/functions.php';
    
    $connection=$conn;
    class Pay_mode{
        private $connect;
        public function __construct() {
    		global $connection;
    		$this->connect=$connection;
    	}
    	
    	public function saveModeEntity($mode_name, $icon){
            $stmt = $this->connect->prepare("INSERT INTO tbl_pay_modes(mode_name, icon) VALUES (?, ?)");
            $stmt->execute([$mode_name, $icon]);
            return;
    	}
    	
    	public function updateModeEntityWithIcon($mode_name, $icon, $pid){
            $stmt = $this->connect->prepare("UPDATE tbl_pay_modes SET mode_name = ?, icon = ? WHERE mode_id = ?");
            $stmt->execute([$mode_name, $icon, $pid]);
            return;
    	}
    	
    	public function updateModeEntityWithoutIcon($mode_name, $pid){
            $stmt = $this->connect->prepare("UPDATE tbl_pay_modes SET mode_name = ? WHERE mode_id = ?");
            $stmt->execute([$mode_name, $pid]);
            return;
    	}
    	
        public function save_mode(){
            $mode_name = $_POST['mode_name'];
            $icon = $_POST['icon'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_pay_modes WHERE mode_name = ?");
            $stmt->execute([$mode_name]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Mode Already exists!");
            }
            else{ 
                $icon = upload_image($icon);
                $this->saveModeEntity($mode_name, $icon);
                sendFeedback(200, "Mode created successfully!");
            }
    	}
    	
        public function view_mode(){
        	$pid = $_POST['pid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_pay_modes WHERE mode_id = ?");
            $stmt->execute([$pid]);
            $data = $stmt->fetch();
            
            sendDataFeedback($data);
            return;
        }
                
        public function update_mode(){
            $pid = $_POST['pid'];    
            $mode_name = $_POST['mode_name'];
            $icon = $_POST['icon'];
            
            $stmt = $this->connect->prepare("SELECT * FROM tbl_pay_modes WHERE mode_name = ? AND mode_id != ?");
            $stmt->execute([$mode_name, $pid]);
        
            if($stmt->rowCount() > 0){
                sendFeedback(400, "Mode Already exists!");
            }
            else{ 
                if($icon !== ""){
                    $icon = upload_image($icon);
                    $this->updateModeEntityWithIcon($mode_name, $icon, $pid);
                }else{
                    $this->updateModeEntityWithoutIcon($mode_name, $pid);
                }
                sendFeedback(200, "Mode updated successfully!");
            }
        }
    
    	public function manage_mode(){
            $pid = $_POST['pid'];
            $stmt = $this->connect->prepare("SELECT * FROM tbl_pay_modes WHERE mode_id = ?");
            $stmt->execute([$pid]);
            $prevData=$stmt->fetch();
            if($prevData['status']==1){
                $status=2;
            }
            else{
                $status=1;
            }
            
            $stmt2 = $this->connect->prepare("UPDATE tbl_pay_modes SET status = ? WHERE mode_id = ?");
            if($stmt2->execute([$status, $pid])){
                sendFeedback(200, "operation done successfully!");
            } else {
                sendFeedback(400, "operation failed!");
            }
        }
    }
    
	$mode=new Pay_mode();
    $action = $_POST['action'];
	switch($action){
	    case 'register':
	        $mode->save_mode();
	        break;
	    case 'update':
	        $mode->update_mode();
	        break;
	    case 'view':
	        $mode->view_mode();
	        break;
	    case 'manage':
	        $mode->manage_mode();
	        break;
	}

?>

